<?php
function ts_remove_product_hooks_shortcode( $options = array() ){
	if( isset($options['show_image']) && !$options['show_image'] ){
		remove_action('woocommerce_before_shop_loop_item_title', 'gon_template_loop_product_thumbnail', 10);
	}
	if( isset($options['show_title']) && !$options['show_title'] ){
		remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_title', 20);
	}
	if( isset($options['show_sku']) && !$options['show_sku'] ){
		remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_sku', 30);
	}
	if( isset($options['show_price']) && !$options['show_price'] ){
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_price', 50);
	}
	if( isset($options['show_short_desc']) && !$options['show_short_desc'] ){
		remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description', 40);
	}
	if( isset($options['show_rating']) && !$options['show_rating'] ){
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_rating', 60);
	}
	if( isset($options['show_label']) && !$options['show_label'] ){
		remove_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_product_label', 1);
	}
	if( isset($options['show_categories']) && !$options['show_categories'] ){
		remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_categories', 10);
	}
	if( isset($options['show_add_to_cart']) && !$options['show_add_to_cart'] ){
		remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_add_to_cart', 70);
		remove_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_add_to_cart', 10001 );
	}
}

function ts_restore_product_hooks_shortcode(){
	add_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_product_label', 1);
	add_action('woocommerce_before_shop_loop_item_title', 'gon_template_loop_product_thumbnail', 10);
	
	add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_categories', 10);
	add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_title', 20);
	add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_product_sku', 30);
	add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_rating', 60);
	add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description', 40); 
	add_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_price', 50);
	add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_add_to_cart', 70); 
	add_action('woocommerce_after_shop_loop_item_title', 'gon_template_loop_add_to_cart', 10001 );
}

function ts_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
	switch( $product_type ){
		case 'sale':
			$args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
		break;
		case 'featured':
			$args['tax_query'][] = array(
				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'featured',
				'operator' => 'IN',
			);
		break;
		case 'best_selling':
			$args['meta_key'] 	= 'total_sales';
			$args['orderby'] 	= 'meta_value_num';
			$args['order'] 		= 'desc';
		break;
		case 'top_rated':
			$args['meta_key'] 	= '_wc_average_rating';
			$args['orderby'] 	= 'meta_value_num';
			$args['order'] 		= 'desc';
		break;
		case 'mixed_order':
			$args['orderby'] 	= 'rand';
		break;
		default: /* Recent */
			$args['orderby'] 	= 'date';
			$args['order'] 		= 'desc';
		break;
	}
}

function ts_get_product_deals_transient(){
	$key = 'all';
	if( defined('ICL_LANGUAGE_CODE') ){
		$key .= '-' . ICL_LANGUAGE_CODE;
	}
	$transient = get_transient('ts_product_deals_ids');
	if( $transient && isset($transient[$key]) && is_array($transient[$key]) ){
		return $transient[$key];
	}
	return false;
}

function ts_set_product_deals_transient( $value = array() ){
	$key = 'all';
	if( defined('ICL_LANGUAGE_CODE') ){
		$key .= '-' . ICL_LANGUAGE_CODE;
	}
	$transient = get_transient('ts_product_deals_ids');
	if( is_array($transient) ){
		$transient[$key] = $value;
	}
	else{
		$transient = array( $key => $value );
	}
	set_transient( 'ts_product_deals_ids', $transient, MONTH_IN_SECONDS );
}

add_action('wc_after_products_starting_sales', 'ts_delete_product_deals_transient');
add_action('wc_after_products_ending_sales', 'ts_delete_product_deals_transient');
add_action('woocommerce_delete_product_transients', 'ts_delete_product_deals_transient');
function ts_delete_product_deals_transient(){
	set_transient( 'ts_product_deals_ids', false, MONTH_IN_SECONDS );
}

function ts_get_product_deals_ids(){
	$product_ids = ts_get_product_deals_transient();
	if( !is_array($product_ids) ){
		global $post;
		$product_ids = array();
		$args = array(
			'post_type'				=> array('product', 'product_variation')
			,'post_status' 			=> 'publish'
			,'posts_per_page' 		=> -1
			,'meta_query' => array(
				array(
					'key'		=> '_sale_price_dates_to'
					,'value'	=> current_time( 'timestamp', true )
					,'compare'	=> '>'
					,'type'		=> 'numeric'
				)
				,array(
					'key'		=> '_sale_price_dates_from'
					,'value'	=> current_time( 'timestamp', true )
					,'compare'	=> '<'
					,'type'		=> 'numeric'
				)
			)
			,'tax_query'			=> array()
		);
		
		$products = new WP_Query( $args );
		
		if( $products->have_posts() ){
			while( $products->have_posts() ){
				$products->the_post();
				if( $post->post_type == 'product' ){
					$product_ids[] = $post->ID;
				}
				else{ /* Variation product */
					$product_ids[] = $post->post_parent;
				}
			}
		}
		$product_ids = array_unique($product_ids);
		ts_set_product_deals_transient($product_ids);
		wp_reset_postdata();
	}
	
	return $product_ids;
}

function ts_template_loop_product_meta_left_open(){
	echo '<div class="meta-left">';
}

function ts_template_loop_product_meta_right_open(){
	echo '<div class="meta-right">';
}

function ts_template_loop_product_meta_close(){
	echo '</div>';
}

/*** Products Shortcode ***/

if( !function_exists('ts_products_shortcode') ){

	function ts_products_shortcode($atts, $content){

		extract(shortcode_atts(array(
				'product_type'			=> 'recent'
				,'custom_order'			=> 0
				,'orderby'				=> 'none'
				,'order'				=> 'DESC'
				,'columns' 				=> 5
				,'style_content' 		=> 'content-border'
				,'per_page' 			=> 5
				,'product_cats'			=> ''
				,'ids'					=> ''
				,'title' 				=> ''
				,'meta_position' 		=> 'bottom'
				,'show_image' 			=> 1
				,'show_title' 			=> 1
				,'show_sku' 			=> 0
				,'show_price' 			=> 1
				,'show_short_desc'  	=> 0
				,'show_rating' 			=> 1
				,'show_label' 			=> 1	
				,'show_categories'		=> 0	
				,'show_add_to_cart' 	=> 1

			), $atts));
			if ( !class_exists('WooCommerce') ){
				return;
			}
			
			$options = array(
					'show_image'		=> $show_image
					,'show_label'		=> $show_label
					,'show_title'		=> $show_title
					,'show_sku'			=> $show_sku
					,'show_price'		=> $show_price
					,'show_short_desc'	=> $show_short_desc
					,'show_categories'	=> $show_categories
					,'show_rating'		=> $show_rating
					,'show_add_to_cart'	=> $show_add_to_cart
				);
			ts_remove_product_hooks_shortcode( $options );
			
			if( $meta_position == 'on-thumbnail' ){
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_left_open', 1);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 35);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_right_open', 35);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 65);
			}
			
			$args = array(
				'post_type'				=> 'product'
				,'post_status' 			=> 'publish'
				,'ignore_sticky_posts'	=> 1
				,'posts_per_page' 		=> $per_page
				,'orderby' 				=> 'date'
				,'order' 				=> 'desc'
				,'meta_query' 			=> WC()->query->get_meta_query()
				,'tax_query'           	=> WC()->query->get_tax_query()
			);
			
			if( $custom_order ){
				$args['orderby'] = $orderby;
				$args['order'] = $order;
			}
			else{
				ts_filter_product_by_product_type($args, $product_type);
			}

			$product_cats = str_replace(' ', '', $product_cats);
			if( strlen($product_cats) > 0 ){
				$product_cats = explode(',', $product_cats);
			}
			if( is_array($product_cats) && count($product_cats) > 0 ){
				$field_name = is_numeric($product_cats[0])?'term_id':'slug';
				$args['tax_query'][] = array(
											'taxonomy' => 'product_cat'
											,'terms' => $product_cats
											,'field' => $field_name
											,'include_children' => false
										);
			}
			
			$ids = str_replace(' ', '', $ids);
			if( strlen($ids) > 0 ){
				$ids = explode(',', $ids);
				if( is_array($ids) && count($ids) > 0 ){
					$args['post__in'] = $ids;
					if( count($ids) == 1 ){
						$columns = 1;
					}
				}
			}
			
			ob_start();
			global $woocommerce_loop;
			if( (int)$columns <= 0 ){
				$columns = 5;
			}
			$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
			$woocommerce_loop['columns'] = $columns;

			$products = new WP_Query( $args );
			
			$classes = array();
			$classes[] = 'ts-product-wrapper ts-shortcode ts-product';
			$classes[] = $style_content;
			$classes[] = $product_type;
			$classes[] = 'meta-'.$meta_position;

			$rand_id = 'ts-product-wrapper-'.rand(0, 10000);
			if( $products->have_posts() ): 
			?>
			<div class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($rand_id); ?>">
				<header class="shortcode-heading-wrapper">
					<?php if( strlen($title) > 0 ): ?>
						<h3 class="heading-title"><?php echo esc_html($title); ?></h3>
					<?php endif; ?>
				</header>
				<div class="content-wrapper">
					<?php woocommerce_product_loop_start(); ?>				

					<?php while( $products->have_posts() ): $products->the_post(); ?>				
							<?php wc_get_template_part( 'content', 'product' ); ?>							
					<?php endwhile; ?>	

					<?php woocommerce_product_loop_end(); ?>
				</div>
			</div>
			<?php
			endif;
			
			wp_reset_postdata();

			/* restore hooks */
			ts_restore_product_hooks_shortcode();
			
			if( $meta_position == 'on-thumbnail' ){
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_left_open', 1);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 35);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_right_open', 35);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 65);
			}

			$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
			return '<div class="woocommerce columns-'.$columns.'">' . ob_get_clean() . '</div>';
	}	
}
add_shortcode('ts_products', 'ts_products_shortcode');

/*** Products Widget ***/
if( !function_exists('ts_products_widget_shortcode') ){
	function ts_products_widget_shortcode($atts, $content){
	
		if( !class_exists('TS_Products_Widget') ){
			return;
		}
	
		extract(shortcode_atts(array(
				'product_type'			=> 'recent'
				,'rows' 				=> 3
				,'per_page' 			=> 6
				,'product_cats'			=> ''
				,'title' 				=> ''
				,'show_image' 			=> 1
				,'show_title' 			=> 1
				,'show_price' 			=> 1
				,'show_rating' 			=> 1	
				,'show_categories'		=> 0	
				,'is_slider'			=> 0
				,'show_nav'				=> 1
				,'auto_play'			=> 1
			), $atts));	
		if( trim($product_cats) != '' ){
			$product_cats = array_map('trim', explode(',', $product_cats));
		}
		
		$instance = array(
			'title'					=> $title
			,'product_type'			=> $product_type
			,'product_cats'			=> $product_cats
			,'row'					=> $rows
			,'limit'				=> $per_page
			,'show_thumbnail' 		=> $show_image
			,'show_categories' 		=> $show_categories
			,'show_product_title' 	=> $show_title
			,'show_price' 			=> $show_price
			,'show_rating' 			=> $show_rating
			,'is_slider'			=> $is_slider
			,'show_nav' 			=> $show_nav
			,'auto_play' 			=> $auto_play
		);
		
		ob_start();
		the_widget('TS_Products_Widget', $instance);
		return ob_get_clean();
	}
}
add_shortcode('ts_products_widget', 'ts_products_widget_shortcode');

/*** Products Slider Shortcode ***/

if( !function_exists('ts_products_slider_shortcode') ){
	function ts_products_slider_shortcode($atts, $content){

		extract(shortcode_atts(array(
				'product_type'			=> 'recent'
				,'custom_order'			=> 0
				,'orderby'				=> 'none'
				,'order'				=> 'DESC'
				,'columns' 				=> 5
				,'rows' 				=> 1
				,'style_content' 		=> 'content-border'
				,'per_page' 			=> 6
				,'product_cats'			=> ''
				,'title' 				=> ''
				,'meta_position' 		=> 'bottom'
				,'show_image' 			=> 1
				,'show_title' 			=> 1
				,'show_sku' 			=> 0
				,'show_price' 			=> 1
				,'show_short_desc'  	=> 0
				,'show_rating' 			=> 1
				,'show_label' 			=> 1	
				,'show_categories'		=> 0	
				,'show_add_to_cart' 	=> 1
				,'show_nav'				=> 1
				,'position_nav'			=> 'nav-top'
				,'auto_play'			=> 0
				,'margin'				=> 20
			), $atts));			

			if ( !class_exists('WooCommerce') ){
				return;
			}
			
			$options = array(
					'show_image'		=> $show_image
					,'show_label'		=> $show_label
					,'show_title'		=> $show_title
					,'show_sku'			=> $show_sku
					,'show_price'		=> $show_price
					,'show_short_desc'	=> $show_short_desc
					,'show_categories'	=> $show_categories
					,'show_rating'		=> $show_rating
					,'show_add_to_cart'	=> $show_add_to_cart
				);
			ts_remove_product_hooks_shortcode( $options );

			if( $meta_position == 'on-thumbnail' ){
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_left_open', 1);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 35);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_right_open', 35);
				add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 65);
			}

			$args = array(
				'post_type'				=> 'product'
				,'post_status' 			=> 'publish'
				,'ignore_sticky_posts'	=> 1
				,'posts_per_page' 		=> $per_page
				,'orderby' 				=> 'date'
				,'order' 				=> 'desc'
				,'meta_query' 			=> WC()->query->get_meta_query()
				,'tax_query'           	=> WC()->query->get_tax_query()
			);
			
			if( $custom_order ){
				$args['orderby'] = $orderby;
				$args['order'] = $order;
			}
			else{
				ts_filter_product_by_product_type($args, $product_type);
			}

			$product_cats = str_replace(' ', '', $product_cats);
			if( strlen($product_cats) > 0 ){
				$product_cats = explode(',', $product_cats);
			}
			if( is_array($product_cats) && count($product_cats) > 0 ){
				$field_name = is_numeric($product_cats[0])?'term_id':'slug';
				$args['tax_query'][] = array(
											'taxonomy' => 'product_cat',
											'terms' => $product_cats,
											'field' => $field_name,
											'include_children' => false
										);
			}			

			ob_start();
			global $woocommerce_loop;
			if( (int)$columns <= 0 ){
				$columns = 5;
			}
			$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
			$woocommerce_loop['columns'] = $columns;
				
			$products = new WP_Query( $args );

			$is_slider = true;
			if( isset($products->post_count) && ( $products->post_count <= 1 || $products->post_count <= $rows ) ){
				$is_slider = false;
			}
			
			$classes = array();
			$classes[] = 'ts-product-slider-wrapper ts-slider ts-shortcode ts-product';
			$classes[] = $style_content;
			$classes[] = $product_type;
			$classes[] = $show_nav?'show-navi':'';
			$classes[] = $position_nav;
			$classes[] = 'meta-'.$meta_position;

			if( $products->have_posts() ): 
			?>
			<div class="<?php echo esc_attr(implode(' ', $classes)); ?>"
				data-nav="<?php echo esc_attr($show_nav) ?>" data-autoplay="<?php echo esc_attr($auto_play) ?>" data-margin="<?php echo esc_attr($margin) ?>" data-columns="<?php echo esc_attr($columns) ?>" data-is_slider="<?php echo esc_attr((int)$is_slider) ?>">
				<header class="shortcode-heading-wrapper">
					<?php if( strlen($title) > 0 ): ?>
						<h3 class="heading-title"><?php echo esc_html($title); ?></h3>
					<?php endif; ?>
				</header>
				<div class="content-wrapper <?php echo ($is_slider)?'loading':''; ?>">
					<?php woocommerce_product_loop_start(); ?>				

					<?php 
					$count = 0;
					while( $products->have_posts() ): $products->the_post();
						if( $rows > 1 && $count % $rows == 0 ){
							echo '<div class="product-group">';
						}
						wc_get_template_part( 'content', 'product' );
						if( $rows > 1 && ($count % $rows == $rows - 1 || $count == $products->post_count - 1) ){
							echo '</div>';
						}
						$count++;
					endwhile; 
					?>			

					<?php woocommerce_product_loop_end(); ?>
				</div>
			</div>
			<?php
			endif;
			
			wp_reset_postdata();			

			/* restore hooks */
			ts_restore_product_hooks_shortcode();
			
			if( $meta_position == 'on-thumbnail' ){
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_left_open', 1);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 35);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_right_open', 35);
				remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_product_meta_close', 65);
			}

			$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
			
			return '<div class="woocommerce">' . ob_get_clean() . '</div>';
	}	
}
add_shortcode('ts_products_slider', 'ts_products_slider_shortcode');

/* Product Category Slider */

if( !function_exists('ts_product_categories_slider_shortcode') ){
	function ts_product_categories_slider_shortcode($atts, $content){
		extract(shortcode_atts(array(
			'title'				=> ''
			,'per_page' 		=> 5
			,'columns' 			=> 4
			,'parent' 			=> ''
			,'child_of' 		=> 0
			,'ids'	 			=> ''
			,'hide_empty'		=> 1
			,'show_title'		=> 1
			,'show_nav' 		=> 1
			,'auto_play' 		=> 1
			,'margin'			=> 0
		),$atts));

		if ( !class_exists('WooCommerce') ){
			return;
		}	
		
		add_filter('subcategory_archive_thumbnail_size', 'ts_product_cat_thumbnail_size_filter', 10);

		$args = array(
			'orderby'     => 'name'
			,'order'      => 'ASC'
			,'hide_empty' => $hide_empty
			,'include'    => array_map('trim', explode(',', $ids))
			,'pad_counts' => true
			,'parent'     => $parent
			,'child_of'   => $child_of
			,'number'     => $per_page
		);
		$product_categories = get_terms('product_cat', $args);	
		global $woocommerce_loop;
		$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
		$woocommerce_loop['columns'] = $columns;	
		
		ob_start();
		
		if( count($product_categories) > 0 ):
			$data_attr = array();
			$data_attr[] = 'data-nav="'.$show_nav.'"';
			$data_attr[] = 'data-autoplay="'.$auto_play.'"';
			$data_attr[] = 'data-margin="'.$margin.'"';
			$data_attr[] = 'data-columns="'.$columns.'"';
		?>
			<div class="ts-product-category-slider-wrapper ts-slider ts-shortcode <?php echo ($show_nav)?'show-navi':''; ?>" <?php echo implode(' ', $data_attr); ?>>
				<header class="shortcode-heading-wrapper">
					<?php if( strlen($title) > 0 ): ?>
						<h3 class="heading-title"><?php echo esc_html($title); ?></h3>
					<?php endif; ?>
				</header>
				<div class="content-wrapper loading">
					<?php 
					woocommerce_product_loop_start();
					foreach ( $product_categories as $category ) {
						wc_get_template( 'content-product_cat.php', array(
							'category' 		=> $category
							,'show_title' 	=> $show_title
						) );
					}
					woocommerce_product_loop_end();
					?>
				</div>
			</div>
		<?php
		endif;
		
		remove_filter('subcategory_archive_thumbnail_size', 'ts_product_cat_thumbnail_size_filter', 10);
		$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
		
		return '<div class="woocommerce">' . ob_get_clean() . '</div>';			
	}
}
add_shortcode('ts_product_categories_slider', 'ts_product_categories_slider_shortcode');

if( !function_exists('ts_product_cat_thumbnail_size_filter') ){
	function ts_product_cat_thumbnail_size_filter( $size ){
		return 'ts_product_cat_thumb';
	}
}

/* TS Product Deals Slider */
if( !function_exists('ts_product_deals_slider_shortcode') ){
	function ts_product_deals_slider_shortcode($atts, $content = null){

		extract(shortcode_atts(array(
				'title' 				=> ''
				,'layout_type' 			=> 'slider'
				,'layout' 				=> 'grid'
				,'columns' 				=> 4
				,'style_content' 		=> 'content-border'
				,'per_page' 			=> 5
				,'product_cats'			=> ''
				,'product_type'			=> 'recent'
				,'show_counter'			=> 1
				,'counter_position'		=> 'bottom' /* bottom - on-thumbnail */
				,'show_image' 			=> 1
				,'show_title' 			=> 1
				,'show_sku' 			=> 0
				,'show_price' 			=> 1
				,'show_short_desc'  	=> 0
				,'show_rating' 			=> 1
				,'show_label' 			=> 1	
				,'show_categories'		=> 0	
				,'show_add_to_cart' 	=> 1
				,'show_nav'				=> 1
				,'auto_play'			=> 1
				,'margin'				=> 20
			), $atts));			

			if ( !class_exists('WooCommerce') ){
				return;
			}
			
			$product_ids_on_sale = ts_get_product_deals_ids();
			
			if( !$product_ids_on_sale ){
				return;
			}
			
			$per_page = absint($per_page);
			
			if( $layout_type == 'grid' ){
				$layout = 'grid';
			}
			
			if( $layout == 'list' ){
				$counter_position = 'bottom';
			}
			
			add_filter('ts_loop_product_thumbnail', 'ts_product_deals_thumbnail_filter', 10);
			
			if( $layout == 'list' && $show_short_desc ){
				add_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description', 65);
				$show_short_desc = 0;
			}
			
			if( $show_counter ){
				if( $counter_position == 'bottom' ){
					add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_time_deals', 65);			
				}
				else{
					add_action('woocommerce_after_shop_loop_item_title', 'ts_template_loop_time_deals', 99);
				}
			}
			
			/* Remove hook */
			$options = array(
					'show_image'		=> $show_image
					,'show_label'		=> $show_label
					,'show_title'		=> $show_title
					,'show_sku'			=> $show_sku
					,'show_price'		=> $show_price
					,'show_short_desc'	=> $show_short_desc
					,'show_categories'	=> $show_categories
					,'show_rating'		=> $show_rating
					,'show_add_to_cart'	=> $show_add_to_cart
				);
			ts_remove_product_hooks_shortcode( $options );

			global $woocommerce_loop, $post, $product;
			if( (int)$columns <= 0 ){
				$columns = 5;
			}
			$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
			$woocommerce_loop['columns'] = $columns;
			
			$args = array(
				'post_type'				=> 'product'
				,'post_status' 			=> 'publish'
				,'posts_per_page' 		=> $per_page
				,'orderby' 				=> 'date'
				,'order' 				=> 'desc'
				,'post__in'				=> $product_ids_on_sale
				,'meta_query' 			=> WC()->query->get_meta_query()
				,'tax_query'           	=> WC()->query->get_tax_query()
			);
			
			ts_filter_product_by_product_type($args, $product_type);
			
			if( $product_cats ){
				$product_cats = array_map('trim', explode(',', $product_cats));
				$args['tax_query'][] = array(
								'taxonomy' 	=> 'product_cat'
								,'terms' 	=> $product_cats
								,'field' 	=> 'term_id'
							);
			}
			
			$products = new WP_Query($args);
			
			$is_slider = ( isset($products->post_count) && $products->post_count > 1 && $layout_type == 'slider' )?true:false;
			
			ob_start();
			
			if( $products->have_posts() ): 
				$classes = array();
				$classes[] = 'ts-product-deals-slider-wrapper ts-shortcode ts-product';
				$classes[] = $style_content;
				$classes[] = $layout;
				$classes[] = $is_slider?'ts-slider':'';
				$classes[] = 'counter-' . $counter_position;
				if( $is_slider && $show_nav ){
					$classes[] = 'show-navi';
				}
				
				$data_attr = array();
				if( $is_slider ){
					$data_attr[] = 'data-nav="'.esc_attr($show_nav).'"';
					$data_attr[] = 'data-autoplay="'.esc_attr($auto_play).'"';
					$data_attr[] = 'data-margin="'.esc_attr($margin).'"';
					$data_attr[] = 'data-columns="'.esc_attr($columns).'"';
					$data_attr[] = 'data-is_slider="'.esc_attr($is_slider).'"';
				}
				?>
				<div class="<?php echo esc_attr( implode(' ', $classes) ); ?>" <?php echo implode(' ', $data_attr); ?>>
					<header class="shortcode-heading-wrapper">
						<?php if( strlen($title) > 0 ): ?>
							<h3 class="heading-title"><?php echo esc_html($title); ?></h3>
						<?php endif; ?>
					</header>
					<div class="content-wrapper <?php echo ($is_slider)?'loading':''; ?>">
						<?php woocommerce_product_loop_start(); ?>				

						<?php while( $products->have_posts() ): $products->the_post(); ?>
							<?php wc_get_template_part( 'content', 'product' ); ?>							
						<?php endwhile; ?>			

						<?php woocommerce_product_loop_end(); ?>
					</div>
				</div>
				<?php
			endif;
			
			wp_reset_postdata();			

			/* restore hooks */
			remove_filter('ts_loop_product_thumbnail', 'ts_product_deals_thumbnail_filter', 10);
			
			if( $layout == 'list' ){
				remove_action('woocommerce_after_shop_loop_item', 'gon_template_loop_short_description', 65);
			}
			
			if( $show_counter ){
				if( $counter_position == 'bottom' ){
					remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_time_deals', 65);			
				}
				else{
					remove_action('woocommerce_after_shop_loop_item_title', 'ts_template_loop_time_deals', 99);
				}
			}

			ts_restore_product_hooks_shortcode();

			$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
			
			return '<div class="woocommerce '.(!$is_slider?'columns-'.$columns:'').'">' . ob_get_clean() . '</div>';
	}
}
add_shortcode('ts_product_deals_slider', 'ts_product_deals_slider_shortcode');

if( !function_exists('ts_product_deals_thumbnail_filter') ){
	function ts_product_deals_thumbnail_filter(){
		return 'ts_product_deal_thumb';
	}
}

if( !function_exists('ts_template_loop_time_deals') ){
	function ts_template_loop_time_deals(){
		global $product;
		$date_to = '';
		$date_from = '';
		if( $product->get_type() == 'variable' ){
			$children = $product->get_children();
			if( is_array($children) && count($children) > 0 ){
				foreach( $children as $children_id ){
					$date_to = get_post_meta($children_id, '_sale_price_dates_to', true);
					$date_from = get_post_meta($children_id, '_sale_price_dates_from', true);
					if( $date_to != '' ){
						break;
					}
				}
			}
		}
		else{
			$date_to = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
			$date_from = get_post_meta($product->get_id(), '_sale_price_dates_from', true);
		}
		
		$current_time = current_time('timestamp', true);
		
		if( $date_to == '' || $date_from == '' || $date_from > $current_time || $date_to < $current_time ){
			return;
		}
		
		$delta = $date_to - $current_time;
		
		$time_day = 60 * 60 * 24;
		$time_hour = 60 * 60;
		$time_minute = 60;
		
		$day = floor( $delta / $time_day );
		$delta -= $day * $time_day;
		
		$hour = floor( $delta / $time_hour );
		$delta -= $hour * $time_hour;
		
		$minute = floor( $delta / $time_minute );
		$delta -= $minute * $time_minute;
		
		if( $delta > 0 ){
			$second = $delta;
		}
		else{
			$second = 0;
		}
		
		$day = zeroise($day, 2);
		$hour = zeroise($hour, 2);
		$minute = zeroise($minute, 2);
		$second = zeroise($second, 2);

		?>
		<div class="counter-wrapper days-<?php echo strlen($day); ?>">
			<div class="days">
				<div class="number-wrapper">
					<span class="number"><?php echo esc_html($day); ?></span>
				</div>
				<div class="ref-wrapper">
					<?php esc_html_e('Days', 'themesky'); ?>
				</div>
			</div>
			<div class="hours">
				<div class="number-wrapper">
					<span class="number"><?php echo esc_html($hour); ?></span>
				</div>
				<div class="ref-wrapper">
					<?php esc_html_e('Hours', 'themesky'); ?>
				</div>
			</div>
			<div class="minutes">
				<div class="number-wrapper">
					<span class="number"><?php echo esc_html($minute); ?></span>
				</div>
				<div class="ref-wrapper">
					<?php esc_html_e('Mins', 'themesky'); ?>
				</div>
			</div>
			<div class="seconds">
				<div class="number-wrapper">
					<span class="number"><?php echo esc_html($second); ?></span>
				</div>
				<div class="ref-wrapper">
					<?php esc_html_e('Secs', 'themesky'); ?>
				</div>
			</div>
		</div>
		<?php
	}
}

/* Product in category tabs */
if( !function_exists('ts_products_in_category_tabs_shortcode') ){
	function ts_products_in_category_tabs_shortcode($atts, $content){

		extract(shortcode_atts(array(
			'title' 						=> ''
			,'color'						=> '#40bea7'
			,'icon_fontawesome' 			=> 'fa fa-info-circle'
			,'icon_image' 					=> ''
			,'banners'						=> ''
			,'links'						=> ''
			,'product_type'					=> 'recent'
			,'custom_order'					=> 0
			,'orderby'						=> 'none'
			,'order'						=> 'DESC'
			,'columns' 						=> 3
			,'per_page' 					=> 6
			,'product_cats'					=> ''
			,'parent_cat' 					=> ''
			,'include_children' 			=> 0
			,'show_general_tab' 			=> 0
			,'general_tab_heading' 			=> ''
			,'product_type_general_tab' 	=> 'recent'
			,'show_image' 					=> 1
			,'show_title' 					=> 1
			,'show_sku' 					=> 0
			,'show_price' 					=> 1
			,'show_short_desc'  			=> 0
			,'show_rating' 					=> 0
			,'show_label' 					=> 1	
			,'show_categories'				=> 0	
			,'show_add_to_cart' 			=> 1
			,'show_see_more_button' 		=> 0
			,'hide_see_more_general_tab' 	=> 0
			,'see_more_button_text' 		=> 'See more'
			,'is_slider' 					=> 0
			,'rows' 						=> 1
			,'show_nav' 					=> 0
			,'auto_play' 					=> 1
		), $atts));
		if ( !class_exists('WooCommerce') ){
			return;
		}
		
		if( empty($product_cats) && empty($parent_cat) ){
			return;
		}
		
		if( empty($product_cats) ){
			$sub_cats = get_terms('product_cat', array('parent' => $parent_cat, 'fields' => 'ids', 'orderby' => 'none'));
			if( is_array($sub_cats) && !empty($sub_cats) ){
				$product_cats = implode(',', $sub_cats);
			}
			else{
				return;
			}
			$see_more_link = get_term_link((int)$parent_cat, 'product_cat');
			if( is_wp_error($see_more_link) ){
				$see_more_link = '#';
			}
		}
		else{
			$see_more_link = get_permalink( wc_get_page_id('shop') );
		}
		
		$atts = compact('title', 'icon_fontawesome', 'icon_image', 'color', 'banners', 'product_type', 'custom_order', 'orderby', 'order', 'columns', 'rows', 'per_page'
						,'product_cats', 'include_children', 'show_image', 'show_title', 'show_sku', 'show_price', 'show_short_desc', 'show_rating', 'show_label'
						,'show_categories', 'show_add_to_cart', 'show_see_more_button', 'hide_see_more_general_tab', 'show_general_tab', 'product_type_general_tab', 'is_slider', 'show_nav', 'auto_play');
		
		$banners_arr = array();
		$banners = str_replace(' ', '', $banners);
		if( $banners != '' ){
			$banners_arr = explode(',', $banners);
		}
		
		$links_arr = array();
		$links = str_replace(' ', '', $links);
		if( $links != '' ){
			$links_arr = explode(',', $links);
		}
		
		$classes = array();
		$classes[] = 'ts-product-in-category-tab-wrapper ts-shortcode ts-product';
		$classes[] = $product_type;
		if( count($banners_arr) == 0 ){
			$classes[] = 'no-banner';
		}
		else{
			$classes[] = 'has-banner';
		}
		
		if( $show_see_more_button ){
			$classes[] = 'has-see-more-button';
		}
		else{
			$classes[] = 'no-see-more-button';
		}
		
		if( $is_slider ){
			$classes[] = 'has-slider';
		}
		
		$rand_id = 'ts-product-in-category-tab-'.rand();
		$selector = '#'.$rand_id;
		
		$inline_style = '<style type="text/css" scoped>';
		$inline_style .= $selector.' .heading-tab i{background-color:'.$color.'}';
		$inline_style .= $selector.'{border-top-color:'.$color.'}';
		// Hover
		$inline_style .= $selector.' .column-tabs .tabs li:hover,'.$selector.' .column-tabs .tabs li.current{background-color:'.$color.'}';
		$inline_style .= '</style>';
		
		$current_cat = '';
		$is_general_tab = false;
		
		ob_start();
		?>
		<div class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($rand_id) ?>" data-atts="<?php echo htmlentities(json_encode($atts)); ?>">
			<?php echo trim($inline_style); ?>
			<div class="column-tabs">
				<header class="heading-tab">
					<?php if( strlen($title) > 0 ): ?>
						<h3 class="heading-title">
							<?php 
							if( !empty($icon_image) ){
								echo wp_get_attachment_image($icon_image);
							}else{ 
							?>
								<i class="<?php echo esc_attr($icon_fontawesome) ?>"></i>
							<?php 
							}
							?>
							<span><?php echo esc_html($title); ?></span>
						</h3>
					<?php endif; ?>
				</header>
				<ul class="tabs">
				<?php 
				if( $show_general_tab ){
					$is_general_tab = true;
					$current_cat = $product_cats;
				?>
					<li class="tab-item general-tab current" data-product_cat="<?php echo esc_attr($product_cats) ?>" data-link="<?php echo esc_url($see_more_link) ?>"><?php echo esc_html($general_tab_heading) ?></li>
				<?php
				}
				
				$product_cats = array_map('trim', explode(',', $product_cats));
				foreach( $product_cats as $k => $product_cat ):
					$term = get_term_by( is_numeric($product_cat)?'term_id':'slug', $product_cat, 'product_cat');
					if( !isset($term->name) ){
						continue;
					}
					$current_tab = false;
					if( $current_cat == '' ){
						$current_tab = true;
						$current_cat = $product_cat;
						$see_more_link = get_term_link($term, 'product_cat');
					}
				?>
					<li class="tab-item <?php echo $current_tab?'current':''; ?>" data-product_cat="<?php echo esc_attr($product_cat) ?>" data-link="<?php echo esc_url(get_term_link($term, 'product_cat')) ?>"><?php echo esc_html($term->name) ?></li>
				<?php
				endforeach;
				?>
				</ul>
			</div>
			<div class="column-products woocommerce columns-<?php echo esc_attr($columns) ?> loading">
				<?php echo ts_get_product_content_in_category_tab($atts, $current_cat, $is_general_tab); ?>
			</div>
			
			<?php if( $show_see_more_button ): ?>
			<div class="see-more-wrapper">
				<a class="button see-more-button" href="<?php echo esc_url($see_more_link) ?>"><?php echo esc_html($see_more_button_text) ?></a>
			</div>
			<?php endif; ?>
			
			<?php if( count($banners_arr) > 0 ): ?>
			<div class="column-banners loading">
				<figure>
				<?php 
				foreach( $banners_arr as $index => $banner ){
					if( isset($links_arr[$index]) ){
						$link = $links_arr[$index];
					}
					else{
						$link = '#';
					}
					
					echo '<a href="'.( $link != '#'? esc_url($link): 'javascript: void(0)' ).'">';
					echo wp_get_attachment_image($banner, 'full');
					echo '</a>';
				}
				?>
				</figure>
			</div>
			<?php endif; ?>
		</div>
		<?php
		
		return ob_get_clean();
	}	
}
add_shortcode('ts_products_in_category_tabs', 'ts_products_in_category_tabs_shortcode');

add_action('wp_ajax_ts_get_product_content_in_category_tab', 'ts_get_product_content_in_category_tab');
add_action('wp_ajax_nopriv_ts_get_product_content_in_category_tab', 'ts_get_product_content_in_category_tab');
if( !function_exists('ts_get_product_content_in_category_tab') ){
	function ts_get_product_content_in_category_tab( $atts = array(), $product_cat = '', $is_general_tab = false ){
		if( wp_doing_ajax() ){
			if( empty($_POST['atts']) || empty($_POST['product_cat']) ){
				die('0');
			}
			$atts = $_POST['atts'];
			$product_cat = $_POST['product_cat'];
			$is_general_tab = (isset($_POST['is_general_tab']) && $_POST['is_general_tab'])?true:false;
		}
		
		if( $is_general_tab ){
			$atts['product_type'] = $atts['product_type_general_tab'];
		}
		
		ob_start();
		extract($atts);
		
		$options = array(
				'show_image'		=> $show_image
				,'show_label'		=> $show_label
				,'show_title'		=> $show_title
				,'show_sku'			=> $show_sku
				,'show_price'		=> $show_price
				,'show_short_desc'	=> $show_short_desc
				,'show_categories'	=> $show_categories
				,'show_rating'		=> $show_rating
				,'show_add_to_cart'	=> $show_add_to_cart
			);
		ts_remove_product_hooks_shortcode( $options );
		
		$args = array(
			'post_type'				=> 'product'
			,'post_status' 			=> 'publish'
			,'ignore_sticky_posts'	=> 1
			,'posts_per_page' 		=> $per_page
			,'orderby' 				=> 'date'
			,'order' 				=> 'desc'
			,'meta_query' 			=> WC()->query->get_meta_query()
			,'tax_query'           	=> WC()->query->get_tax_query()
		);
		
		if( $custom_order ){
			$args['orderby'] 	= $orderby;
			$args['order'] 		= $order;
		}
		else{
			ts_filter_product_by_product_type($args, $product_type);
		}
		
		$args['tax_query'][] = array(
									'taxonomy' => 'product_cat'
									,'terms' => array_map('trim', explode(',', $product_cat))
									,'field' => 'term_id'
									,'include_children' => $include_children
								);
		
		global $woocommerce_loop;
		if( (int)$columns <= 0 ){
			$columns = 3;
		}
		$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
		$woocommerce_loop['columns'] = $columns;

		$products = new WP_Query( $args );
		
		$count = 0;
		
		woocommerce_product_loop_start();
		if( $products->have_posts() ){	

			if( isset($products->found_posts, $products->post_count) && $products->found_posts == $products->post_count ){
				echo '<div class="hidden hide-see-more"></div>';
			}

			while( $products->have_posts() ){ 
				$products->the_post();
				
				if( $is_slider && $count % $rows == 0 ){
					echo '<div class="product-group">';
				}
				
				wc_get_template_part( 'content', 'product' );
				
				if( $is_slider && ($count % $rows == $rows - 1 || $count == $products->post_count - 1) ){
					echo '</div>';
				}
				$count++;
			}

		}
		woocommerce_product_loop_end();
		
		wp_reset_postdata();

		/* restore hooks */
		ts_restore_product_hooks_shortcode();

		$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
		
		if( wp_doing_ajax() ){
			die(ob_get_clean());
		}
		else{
			return ob_get_clean();
		}
	}
}

/* Product in category tabs 2 */
if( !function_exists('ts_products_in_category_tabs_2_shortcode') ){
	function ts_products_in_category_tabs_2_shortcode($atts, $content){

		extract(shortcode_atts(array(
			'product_type'					=> 'recent'
			,'custom_order'					=> 0
			,'orderby'						=> 'none'
			,'order'						=> 'DESC'
			,'bg_color'						=> '#f7f6f4'
			,'columns' 						=> 3
			,'per_page' 					=> 6
			,'product_cats'					=> ''
			,'parent_cat'					=> ''
			,'include_children'				=> 0
			,'active_tab'					=> 1
			,'show_image' 					=> 1
			,'show_title' 					=> 1
			,'show_sku' 					=> 0
			,'show_price' 					=> 1
			,'show_short_desc'  			=> 0
			,'show_rating' 					=> 1
			,'show_label' 					=> 1	
			,'show_categories'				=> 0	
			,'show_add_to_cart' 			=> 1
			,'show_counter'					=> 1
			,'is_slider' 					=> 0
			,'rows' 						=> 1
			,'show_nav' 					=> 0
			,'auto_play' 					=> 1
		), $atts));
		if ( !class_exists('WooCommerce') ){
			return;
		}
		
		if( empty($product_cats) && empty($parent_cat) ){
			return;
		}
		
		if( empty($product_cats) ){
			$sub_cats = get_terms('product_cat', array('parent' => $parent_cat, 'fields' => 'ids', 'orderby' => 'none'));
			if( is_array($sub_cats) && !empty($sub_cats) ){
				$product_cats = implode(',', $sub_cats);
			}
			else{
				return;
			}
		}
		
		$active_tab = absint($active_tab);
		
		$atts = compact('product_type', 'custom_order', 'orderby', 'order', 'columns', 'rows', 'per_page', 'product_cats', 'include_children', 'active_tab'
						,'show_image', 'show_title', 'show_sku', 'show_price', 'show_short_desc', 'show_rating', 'show_label'
						,'show_categories', 'show_add_to_cart', 'show_counter', 'is_slider', 'show_nav', 'auto_play');
		
		$product_cats = array_map('trim', explode(',', $product_cats));
		
		$classes = array();
		$classes[] = 'ts-product-in-category-tab-2-wrapper ts-shortcode ts-product';
		$classes[] = $product_type;
		
		$classes[] = 'count-'.count($product_cats);
		
		if( $is_slider ){
			$classes[] = 'has-slider';
		}
		
		$rand_id = 'ts-product-in-category-tab-2-'.rand();
		$selector = '#'.$rand_id;
		
		$inline_style = '<style type="text/css" scoped>';
		$inline_style .= $selector.'{background-color:'.$bg_color.'}';
		$inline_style .= $selector.' ul.tabs li.current,'.$selector.' ul.tabs li:hover{background-color:'.$bg_color.'}';
		$inline_style .= $selector.' ul.tabs li.current:after,'.$selector.' ul.tabs li:hover:after{border-bottom-color:'.$bg_color.'}';
		$inline_style .= $selector.' .row-content.loading:before{background-color:'.$bg_color.'}';
		foreach( $product_cats as $k => $product_cat ){
			$border_top_color = get_term_meta((int) $product_cat, 'shortcode_border_top_color', true);
			if( !empty($border_top_color) ){
				$inline_style .= $selector.' ul.tabs li.current.product-cat-'.$product_cat.':before,'.$selector.' ul.tabs li.product-cat-'.$product_cat.':hover:before{border-top-color:'.$border_top_color.'}';
			}
		}
		$inline_style .= '</style>';
		$current_cat = '';
		ob_start();
		
		?>
		<div class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($rand_id) ?>" data-atts="<?php echo htmlentities(json_encode($atts)); ?>">
			<?php echo trim($inline_style); ?>
			<div class="row-tabs">
				<ul class="tabs">
				<?php 
				if( $active_tab > count($product_cats) ){
					$active_tab = 1;
				}
				foreach( $product_cats as $k => $product_cat ):
					$term = get_term_by('term_id', $product_cat, 'product_cat');
					if( !isset($term->name) ){
						continue;
					}
					$has_icon = false;
					$icon_id = get_term_meta($term->term_id, 'shortcode_icon_id', true);
					if( !empty($icon_id) ){
						$has_icon = true;
					}
					
					$current_tab = false;
					if( $active_tab == $k + 1 ){
						$current_tab = true;
						$current_cat = $product_cat;
					}
				?>
					<li class="tab-item <?php echo ($has_icon)?'has-icon':'no-icon'; ?> product-cat-<?php echo esc_attr($product_cat) ?> <?php echo $current_tab?'current':''; ?>" data-product_cat="<?php echo esc_attr($product_cat) ?>">
						<span class="icon"><?php echo ($has_icon)?wp_get_attachment_image($icon_id):''; ?></span>
						<span class="title"><?php echo esc_html($term->name) ?></span>
					</li>
				<?php
				endforeach;
				?>
				</ul>
			</div>
			<div class="row-content loading">
				<?php
				if( $current_cat ){
					echo ts_get_product_content_in_category_tab_2($atts, $current_cat);
				}
				?>
			</div>
		</div>
		<?php
		
		return ob_get_clean();
	}	
}
add_shortcode('ts_products_in_category_tabs_2', 'ts_products_in_category_tabs_2_shortcode');

add_action('wp_ajax_ts_get_product_content_in_category_tab_2', 'ts_get_product_content_in_category_tab_2');
add_action('wp_ajax_nopriv_ts_get_product_content_in_category_tab_2', 'ts_get_product_content_in_category_tab_2');
if( !function_exists('ts_get_product_content_in_category_tab_2') ){
	function ts_get_product_content_in_category_tab_2( $atts = array(), $product_cat = '' ){
		if( wp_doing_ajax() ){
			if( empty($_POST['atts']) || empty($_POST['product_cat']) ){
				die('0');
			}
			$atts = $_POST['atts'];
			$product_cat = $_POST['product_cat'];
		}
		
		ob_start();
		extract($atts);
		
		$options = array(
				'show_image'		=> $show_image
				,'show_label'		=> $show_label
				,'show_title'		=> $show_title
				,'show_sku'			=> $show_sku
				,'show_price'		=> $show_price
				,'show_short_desc'	=> $show_short_desc
				,'show_categories'	=> $show_categories
				,'show_rating'		=> $show_rating
				,'show_add_to_cart'	=> $show_add_to_cart
			);
		ts_remove_product_hooks_shortcode( $options );
		
		if( $show_counter ){
			add_action('ts_after_shop_loop_item', 'ts_template_loop_time_deals', 10);
		}
		
		add_filter('ts_display_add_to_cart_button_on_thumbnail', '__return_false', 10);
		
		$args = array(
			'post_type'				=> 'product'
			,'post_status' 			=> 'publish'
			,'ignore_sticky_posts'	=> 1
			,'posts_per_page' 		=> $per_page
			,'orderby' 				=> 'date'
			,'order' 				=> 'desc'
			,'meta_query' 			=> WC()->query->get_meta_query()
			,'tax_query'           	=> WC()->query->get_tax_query()
		);
		
		if( $custom_order ){
			$args['orderby'] = $orderby;
			$args['order'] = $order;
		}
		else{
			ts_filter_product_by_product_type($args, $product_type);
		}
		
		$args['tax_query'][] = array(
									'taxonomy' => 'product_cat'
									,'terms' => explode(',', $product_cat)
									,'field' => 'term_id'
									,'include_children' => $include_children
								);
		
		global $woocommerce_loop;
		if( (int)$columns <= 0 ){
			$columns = 3;
		}
		$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
		$woocommerce_loop['columns'] = $columns;

		$products = new WP_Query( $args );
		
		$count = 0;
		
		echo '<div class="column-products woocommerce columns-'.esc_attr($columns).'">';
		woocommerce_product_loop_start();
		if( $products->have_posts() ){	

			if( isset($products->post_count) && $products->post_count == 0 ){
				echo '<div class="hidden flag-no-product"></div>';
			}

			while( $products->have_posts() ){ 
				$products->the_post();
				
				if( $is_slider && $count % $rows == 0 ){
					echo '<div class="product-group">';
				}
				
				wc_get_template_part( 'content', 'product' );
				
				if( $is_slider && ($count % $rows == $rows - 1 || $count == $products->post_count - 1) ){
					echo '</div>';
				}
				$count++;
			}

		}
		woocommerce_product_loop_end();
		echo '</div>';
		?>
		<div class="column-banners">
			<figure>
			<?php 
			$banner_id = get_term_meta((int) $product_cat, 'shortcode_banner_id', true);
			if( !empty($banner_id) ){
				$link = get_term_link((int) $product_cat, 'product_cat');
				echo '<a href="'.( is_string($link)? esc_url($link): 'javascript: void(0)' ).'">';
				echo wp_get_attachment_image($banner_id, 'full');
				echo '</a>';
			}
			else{
				echo '<div class="hidden flag-no-banner"></div>';
			}
			?>
			</figure>
		</div>
		<?php
		
		wp_reset_postdata();

		/* restore hooks */
		ts_restore_product_hooks_shortcode();
		
		if( $show_counter ){
			remove_action('ts_after_shop_loop_item', 'ts_template_loop_time_deals', 10);
		}
		
		remove_filter('ts_display_add_to_cart_button_on_thumbnail', '__return_false', 10);

		$woocommerce_loop['columns'] = $old_woocommerce_loop_columns;
		
		if( wp_doing_ajax() ){
			die(ob_get_clean());
		}
		else{
			return ob_get_clean();
		}
	}
}

/* Product in sub category tabs */
if( !function_exists('ts_products_in_sub_category_tabs_shortcode') ){
	function ts_products_in_sub_category_tabs_shortcode($atts, $content){

		extract(shortcode_atts(array(
			'title' 				=> ''
			,'color_title'			=> '#66b1d4'
			,'color_icon'			=> '#73d2ff'
			,'icon_fontawesome' 	=> 'fa fa-info-circle'
			,'icon_image' 			=> ''
			,'banners'				=> ''
			,'links'				=> ''
			,'banner_position'		=> 'bottom'
			,'product_type'			=> 'recent'
			,'custom_order'			=> 0
			,'orderby'				=> 'none'
			,'order'				=> 'DESC'
			,'per_page' 			=> 6
			,'rows' 				=> 1
			,'product_cat'			=> ''
			,'limit_sub_cat'		=> 6
			,'link_all_text'		=> 'All'
			,'featured_product'		=> ''
			,'show_image' 			=> 1
			,'show_title' 			=> 1
			,'show_sku' 			=> 0
			,'show_price' 			=> 1
			,'show_short_desc'  	=> 0
			,'show_rating' 			=> 0
			,'show_label' 			=> 1	
			,'show_categories'		=> 0	
			,'show_add_to_cart' 	=> 1
			,'show_nav'				=> 0
			,'auto_play'			=> 1
		), $atts));
		if ( !class_exists('WooCommerce') ){
			return;
		}
		
		$product_cat_obj = get_term($product_cat, 'product_cat');
		if( empty($product_cat) || is_wp_error($product_cat_obj) || $product_cat_obj == null ){
			return;
		}
		
		$atts = compact('product_type', 'custom_order', 'orderby', 'order', 'per_page', 'rows'
						,'product_cat', 'limit_sub_cat', 'featured_product', 'show_image', 'show_title', 'show_sku', 'show_price', 'show_short_desc'
						,'show_rating', 'show_label', 'show_categories', 'show_add_to_cart', 'show_nav', 'auto_play');
		
		$banners_arr = array();
		$banners = str_replace(' ', '', $banners);
		if( $banners != '' ){
			$banners_arr = explode(',', $banners);
		}
		
		$links_arr = array();
		$links = str_replace(' ', '', $links);
		if( $links != '' ){
			$links_arr = explode(',', $links);
		}
		
		$classes = array();
		$classes[] = 'ts-product-in-sub-category-tab-wrapper ts-shortcode ts-product';
		$classes[] = $product_type;
		$classes[] = 'banner-' . $banner_position;
		$classes[] = 'rows-' . $rows;
		if( count($banners_arr) == 0 ){
			$classes[] = 'no-banner';
		}
		else{
			$classes[] = 'has-banner';
		}
		
		if( empty($featured_product) ){
			$classes[] = 'no-featured-product';
		}
		
		if( $limit_sub_cat == 0 ){
			$classes[] = 'no-tabs';
		}
		
		global $smof_data;
		$is_rtl = ( isset($smof_data['ts_enable_rtl']) && $smof_data['ts_enable_rtl'] )? true: false;
		
		$rand_id = 'ts-product-in-sub-category-tab-'.mt_rand(0, 1000);
		$selector = '#'.$rand_id;
		
		$inline_style = '<style type="text/css" scoped>';
		if( $is_rtl ){
			$inline_style .= $selector.' .row-heading-tabs .heading-tab .heading-title:after{border-right-color:'.$color_title.'}';
		}
		else{
			$inline_style .= $selector.' .row-heading-tabs .heading-tab .heading-title:after{border-left-color:'.$color_title.'}';
		}
		$inline_style .= $selector.' .row-heading-tabs .heading-tab .heading-title:before{background-color:'.$color_title.'}';
		$inline_style .= $selector.' .row-heading-tabs ul li:hover{color:'.$color_title.'}';
		$inline_style .= $selector.' .row-heading-tabs ul li a:hover{color:'.$color_title.'}';
		$inline_style .= $selector.' .row-heading-tabs ul li.current{color:'.$color_title.'}';
		$inline_style .= $selector.' .row-heading-tabs .heading-tab .heading-title i{background-color:'.$color_icon.'}';
		$inline_style .= '</style>';
		
		$current_cat = $product_cat;
		ob_start();
		
		?>
		<div class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($rand_id) ?>" data-atts="<?php echo htmlentities(json_encode($atts)); ?>">
			<?php echo trim($inline_style); ?>
			<div class="row-heading-tabs">
				<header class="heading-tab">
					<?php if( strlen($title) > 0 ): ?>
						<h3 class="heading-title">
							<?php 
							if( !empty($icon_image) ){
								echo wp_get_attachment_image($icon_image);
							}else{ 
							?>
								<i class="<?php echo esc_attr($icon_fontawesome) ?>"></i>
							<?php 
							}
							?>
							<span><?php echo esc_html($title); ?></span>
						</h3>
					<?php endif; ?>
				</header>
				<ul class="tabs">
					<li class="tab-item hidden parent-cat" data-product_cat="<?php echo esc_attr($product_cat) ?>"></li>
				<?php 
				if( $limit_sub_cat != 0 ){
					$sub_cats = get_terms('product_cat', array('parent' => $product_cat, 'number' => $limit_sub_cat));
					if( is_array($sub_cats) ){
						foreach( $sub_cats as $k => $sub_cat ){
							$current_tab = false;
							if( $k == 0 ){
								$current_tab = true;
								$current_cat = $sub_cat->term_id;
							}
						?>
							<li class="tab-item <?php echo $current_tab?'current':''; ?>" data-product_cat="<?php echo esc_attr($sub_cat->term_id) ?>"><?php echo esc_html($sub_cat->name) ?></li>
						<?php
						}
					}
				}
				?>
					<li class="tab-item link-to-all">
						<a href="<?php echo get_term_link((int)$product_cat, 'product_cat') ?>"><?php echo esc_html($link_all_text) ?></a>
					</li>
				</ul>
			</div>
			
			<?php if( !empty($featured_product) ): ?>
			<div class="column-featured-product woocommerce">
			<?php 
				$options = array(
					'show_image'		=> $show_image
					,'show_label'		=> $show_label
					,'show_title'		=> $show_title
					,'show_sku'			=> $show_sku
					,'show_price'		=> $show_price
					,'show_short_desc'	=> $show_short_desc
					,'show_categories'	=> $show_categories
					,'show_rating'		=> $show_rating
					,'show_add_to_cart'	=> $show_add_to_cart
				);
				ts_remove_product_hooks_shortcode( $options );
				
				if( function_exists('ts_template_loop_time_deals') ){
					add_action('woocommerce_after_shop_loop_item', 'ts_template_loop_time_deals', 65);
				}
				
				$args = array(
					'post_type'				=> 'product'
					,'post_status' 			=> 'publish'
					,'ignore_sticky_posts'	=> 1
					,'p'					=> $featured_product
					,'meta_query' 			=> WC()->query->get_meta_query()
					,'tax_query'           	=> WC()->query->get_tax_query()
				);
				
				add_filter('ts_loop_product_thumbnail', 'ts_product_deals_thumbnail_filter', 10);
				
				$products = new WP_Query( $args );
				if( $products->have_posts() ){
					woocommerce_product_loop_start();
					while( $products->have_posts() ){
						$products->the_post();	
						wc_get_template_part( 'content', 'product' );
					}
					woocommerce_product_loop_end();
				}
				
				remove_filter('ts_loop_product_thumbnail', 'ts_product_deals_thumbnail_filter', 10);
				
				if( function_exists('ts_template_loop_time_deals') ){
					remove_action('woocommerce_after_shop_loop_item', 'ts_template_loop_time_deals', 65);
				}
				
				wp_reset_postdata();
				
			?>
			</div>
			<?php endif; ?>
			
			<div class="column-product-banner">
				<?php 
				if( $banner_position == 'top' ){
					ts_get_banner_in_sub_category_tab( $banners_arr, $links_arr );
				}
				?>
				
				<div class="row-products woocommerce loading">
					<?php echo ts_get_product_content_in_sub_category_tab($atts, $current_cat); ?>
				</div>
				
				<?php 
				if( $banner_position == 'bottom' ){
					ts_get_banner_in_sub_category_tab( $banners_arr, $links_arr );
				}
				?>
			</div>
			
		</div>
		<?php
		
		return ob_get_clean();
	}	
}
add_shortcode('ts_products_in_sub_category_tabs', 'ts_products_in_sub_category_tabs_shortcode');

if( !function_exists('ts_get_banner_in_sub_category_tab') ){
	function ts_get_banner_in_sub_category_tab( $banners_arr, $links_arr ){
	?>
		<div class="row-banners loading">
			<figure>
			<?php 
			foreach( $banners_arr as $index => $banner ){
				if( isset($links_arr[$index]) ){
					$link = $links_arr[$index];
				}
				else{
					$link = '#';
				}
				
				echo '<a href="'.( $link != '#'? esc_url($link): 'javascript: void(0)' ).'">';
				echo wp_get_attachment_image($banner, 'full');
				echo '</a>';
			}
			?>
			</figure>
		</div>
	<?php
	}
}

add_action('wp_ajax_ts_get_product_content_in_sub_category_tab', 'ts_get_product_content_in_sub_category_tab');
add_action('wp_ajax_nopriv_ts_get_product_content_in_sub_category_tab', 'ts_get_product_content_in_sub_category_tab');
if( !function_exists('ts_get_product_content_in_sub_category_tab') ){
	function ts_get_product_content_in_sub_category_tab( $atts = array(), $product_cat = '' ){
		if( wp_doing_ajax() ){
			if( !isset($_POST['atts']) ){
				die('0');
			}
			$atts = $_POST['atts'];
			if( !empty($_POST['product_cat']) ){
				$atts['product_cat'] = $_POST['product_cat'];
			}
		}
		else{
			$atts['product_cat'] = $product_cat;
		}
		
		extract($atts);
		
		if( empty($product_cat) ){
			die('0');
		}
		
		ob_start();
		
		$options = array(
				'show_image'		=> $show_image
				,'show_label'		=> $show_label
				,'show_title'		=> $show_title
				,'show_sku'			=> $show_sku
				,'show_price'		=> $show_price
				,'show_short_desc'	=> $show_short_desc
				,'show_categories'	=> $show_categories
				,'show_rating'		=> $show_rating
				,'show_add_to_cart'	=> $show_add_to_cart
			);
		ts_remove_product_hooks_shortcode( $options );
		
		$args = array(
			'post_type'				=> 'product'
			,'post_status' 			=> 'publish'
			,'ignore_sticky_posts'	=> 1
			,'posts_per_page' 		=> $per_page
			,'orderby' 				=> 'date'
			,'order' 				=> 'desc'
			,'meta_query' 			=> WC()->query->get_meta_query()
			,'tax_query'           	=> WC()->query->get_tax_query()
		);

		if( !empty($featured_product) ){
			$args['post__not_in'] = array($featured_product);
		}
		
		if( $custom_order ){
			$args['orderby'] = $orderby;
			$args['order'] = $order;
		}
		else{
			ts_filter_product_by_product_type($args, $product_type);
		}
		
		$field_name = is_numeric($product_cat)?'term_id':'slug';
		$args['tax_query'][] = array(
									'taxonomy' => 'product_cat'
									,'terms' => $product_cat
									,'field' => $field_name
									,'include_children' => true
								);

		$products = new WP_Query( $args );
		
		$count = 0;
		
		woocommerce_product_loop_start();
		if( $products->have_posts() ){			

			while( $products->have_posts() ){ 
				$products->the_post();	
				
				if( $rows == 2 && $count % $rows == 0 ){
					echo '<div class="product-group">';
				}
				
				wc_get_template_part( 'content', 'product' );		

				if( $rows == 2 && ($count % $rows == $rows - 1 || $count == $products->post_count - 1) ){
					echo '</div>';
				}
				$count++;
			}

		}
		woocommerce_product_loop_end();
		
		wp_reset_postdata();

		/* restore hooks */
		ts_restore_product_hooks_shortcode();
		
		if( wp_doing_ajax() ){
			die(ob_get_clean());
		}
		else{
			return ob_get_clean();
		}
	}
}

if( !function_exists('ts_list_of_product_categories_shortcode') ){
	function ts_list_of_product_categories_shortcode( $atts ){
		extract(shortcode_atts(array(
			'title' 				=> ''
			,'bg_image'				=> ''
			,'product_cat'			=> ''
			,'include_parent'		=> 1
			,'limit_sub_cat'		=> 6
			,'include_cats'			=> ''
		), $atts));
		
		if( empty($product_cat) && empty($include_cats) ){
			return;
		}
		
		ob_start();
		
		$bg_image_url = wp_get_attachment_url( $bg_image );
		
		$list_categories = array();
		
		if( !empty($product_cat) ){
			$list_categories = get_terms('product_cat', array('child_of' => $product_cat, 'number' => $limit_sub_cat));
		}
		else if( !empty($include_cats) ){
			$include_parent = false;
			$include_cats = array_map('trim', explode(',', $include_cats));
			$list_categories = get_terms('product_cat', array('include' => $include_cats, 'orderby' => 'none'));
		}
		?>
		<div class="ts-list-of-product-categories-wrapper ts-shortcode" style="background-image: url(<?php echo esc_url($bg_image_url); ?>)">
			<?php if( $title ): ?>
			<h3 class="heading-title"><?php echo esc_html($title) ?></h3>
			<?php endif; ?>
			<ul class="list-categories">
				<?php 
				if( $include_parent ){
					$parent_obj = get_term($product_cat, 'product_cat');
					if( !is_wp_error($parent_obj) && $parent_obj != null ){
				?>
					<li><a href="<?php echo get_term_link($parent_obj, 'product_cat'); ?>"><?php echo esc_html($parent_obj->name) ?></a></li>
				<?php 
					}
				}
				if( !empty($list_categories) && is_array($list_categories) ){
					foreach( $list_categories as $cat ){
					?>
					<li><a href="<?php echo get_term_link($cat, 'product_cat'); ?>"><?php echo esc_html($cat->name) ?></a></li>
					<?php
					}
				}
				?>
			</ul>
		</div>
		<?php
		return ob_get_clean();
	}	
}
add_shortcode('ts_list_of_product_categories', 'ts_list_of_product_categories_shortcode');
?>