<?php
global $post;
$theme_options = gon_get_theme_options();
$from_shortcode = false;

if ( !isset( $post->ID ) && ! isset( $_GET['product_id'] ) ) {
    wp_die( esc_html__( 'Access Denied, No product found', 'gon' ) );
}

if( isset( $post->ID ) && $post->ID && $post->post_type == 'product' ) {
    $post_id = $post->ID;
    $post_title = $post->post_title;
    $post_content = $post->post_content;
    $post_excerpt = $post->post_excerpt;
    $post_status = $post->post_status;
    $product        = wc_get_product( $post_id );
}

if ( isset( $_GET['product_id'] ) ) {
    $post_id        = intval( $_GET['product_id'] );
    $post           = get_post( $post_id );
    $post_title     = $post->post_title;
    $post_content   = $post->post_content;
    $post_excerpt   = $post->post_excerpt;
    $post_status    = $post->post_status;
    $product        = wc_get_product( $post_id );
    $from_shortcode = true;
}

if ( ! dokan_is_product_author( $post_id ) ) {
    wp_die( esc_html__( 'Access Denied', 'gon' ) );
    exit();
}

$_regular_price         = get_post_meta( $post_id, '_regular_price', true );
$_sale_price            = get_post_meta( $post_id, '_sale_price', true );
$is_discount            = !empty( $_sale_price ) ? true : false;
$_sale_price_dates_from = get_post_meta( $post_id, '_sale_price_dates_from', true );
$_sale_price_dates_to   = get_post_meta( $post_id, '_sale_price_dates_to', true );

$_sale_price_dates_from = !empty( $_sale_price_dates_from ) ? date_i18n( 'Y-m-d', $_sale_price_dates_from ) : '';
$_sale_price_dates_to   = !empty( $_sale_price_dates_to ) ? date_i18n( 'Y-m-d', $_sale_price_dates_to ) : '';
$show_schedule          = false;

if ( !empty( $_sale_price_dates_from ) && !empty( $_sale_price_dates_to ) ) {
    $show_schedule          = true;
}

$_featured              = get_post_meta( $post_id, '_featured', true );
$terms                  = wp_get_object_terms( $post_id, 'product_type' );
$product_type           = ( ! empty( $terms ) ) ? sanitize_title( current( $terms )->name ): 'simple';
$variations_class       = ($product_type == 'simple' ) ? 'dokan-hide' : '';
$_visibility        = ( version_compare( WC_VERSION, '2.7', '>' ) ) ? $product->get_catalog_visibility() : get_post_meta( $post_id, '_visibility', true );

if ( ! $from_shortcode ) {
    get_header( $theme_options['ts_header_layout'] );
}
?>

<?php

    /**
     *  dokan_dashboard_wrap_before hook
     *
     *  @since 2.4
     */
    do_action( 'dokan_dashboard_wrap_before', $post, $post_id );
	
	if( ! $from_shortcode ){
		gon_breadcrumbs_title(true, true, get_the_title());
	}
?>
<?php if( ! $from_shortcode ): ?>
<div class="page-container show_breadcrumb_<?php echo esc_attr($theme_options['ts_breadcrumb_layout']) ?>">
<div id="main-content" class="ts-col-24">
<?php endif; ?>

<?php do_action( 'dokan_dashboard_wrap_start' ); ?>

    <div class="dokan-dashboard-wrap">

        <?php

            /**
             *  dokan_dashboard_content_before hook
             *  dokan_before_product_content_area hook
             *
             *  @hooked get_dashboard_side_navigation
             *
             *  @since 2.4
             */
            do_action( 'dokan_dashboard_content_before' );
            do_action( 'dokan_before_product_content_area' );
        ?>

        <div class="dokan-dashboard-content dokan-product-edit">

            <?php

                /**
                 *  dokan_product_content_inside_area_before hook
                 *
                 *  @since 2.4
                 */
                do_action( 'dokan_product_content_inside_area_before' );
            ?>

            <header class="dokan-dashboard-header dokan-clearfix">
                <h1 class="entry-title">
                    <?php esc_html_e( 'Edit Product', 'gon' ); ?>
                    <span class="dokan-label <?php echo dokan_get_post_status_label_class( $post->post_status ); ?> dokan-product-status-label">
                        <?php echo dokan_get_post_status( $post->post_status ); ?>
                    </span>

                    <?php if ( $post->post_status == 'publish' ) { ?>
                        <span class="dokan-right">
                            <a class="dokan-btn dokan-btn-theme dokan-btn-sm" href="<?php echo get_permalink( $post->ID ); ?>" target="_blank"><?php esc_html_e( 'View Product', 'gon' ); ?></a>
                        </span>
                    <?php } ?>

                    <?php if ( $_visibility == 'hidden' ) { ?>
                        <span class="dokan-right dokan-label dokan-label-default dokan-product-hidden-label"><i class="fa fa-eye-slash"></i> <?php esc_html_e( 'Hidden', 'gon' ); ?></span>
                    <?php } ?>
                </h1>
            </header><!-- .entry-header -->

            <div class="product-edit-new-container product-edit-container">
                <?php if ( Dokan_Template_Products::$errors ) { ?>
                    <div class="dokan-alert dokan-alert-danger">
                        <a class="dokan-close" data-dismiss="alert">&times;</a>

                        <?php foreach ( Dokan_Template_Products::$errors as $error) { ?>
                            <strong><?php esc_html_e( 'Error!', 'gon' ); ?></strong> <?php echo wp_kses_post($error); ?>.<br>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php if ( isset( $_GET['message'] ) && $_GET['message'] == 'success') { ?>
                    <div class="dokan-message">
                        <button type="button" class="dokan-close" data-dismiss="alert">&times;</button>
                        <strong><?php esc_html_e( 'Success!', 'gon' ); ?></strong> <?php esc_html_e( 'The product has been saved successfully.', 'gon' ); ?>

                        <?php if ( $post->post_status == 'publish' ) { ?>
                            <a href="<?php echo get_permalink( $post_id ); ?>" target="_blank"><?php esc_html_e( 'View Product &rarr;', 'gon' ); ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php
                $can_sell = apply_filters( 'dokan_can_post', true );

                if ( $can_sell ) {

                    if ( dokan_is_seller_enabled( get_current_user_id() ) ) { ?>
                        <form class="dokan-product-edit-form" role="form" method="post">

                            <?php do_action( 'dokan_product_data_panel_tabs' ); ?>
                            <?php do_action( 'dokan_product_edit_before_main' ); ?>

                            <div class="dokan-form-top-area">

                                <div class="content-half-part dokan-product-meta">

                                    <div class="dokan-form-group">
                                        <input type="hidden" name="dokan_product_id" id="dokan-edit-product-id" value="<?php echo esc_attr($post_id); ?>"/>

                                        <label for="post_title" class="form-label"><?php esc_html_e( 'Title', 'gon' ); ?></label>
                                        <?php dokan_post_input_box( $post_id, 'post_title', array( 'placeholder' => esc_html__( 'Product name..', 'gon' ), 'value' => $post_title ) ); ?>
                                        <div class="dokan-product-title-alert dokan-hide">
                                            <?php esc_html_e( 'Please enter product title!', 'gon' ); ?>
                                        </div>
                                    </div>

                                    <?php $product_types = apply_filters( 'dokan_product_types', 'simple' ); ?>

                                    <?php if( 'simple' === $product_types ): ?>
                                            <input type="hidden" id="product_type" name="product_type" value="simple">
                                    <?php endif; ?>

                                    <?php if ( is_array( $product_types ) ): ?>
                                        <div class="dokan-form-group">
                                            <label for="product_type" class="form-label"><?php esc_html_e( 'Product Type', 'gon' ); ?> <i class="fa fa-question-circle tips" aria-hidden="true" data-title="<?php esc_html_e( 'Choose Variable if your product has multiple attributes - like sizes, colors, quality etc', 'gon' ); ?>"></i></label>
                                            <select name="product_type" class="dokan-form-control" id="product_type">
                                                <?php foreach ( $product_types as $key => $value ) { ?>
                                                    <option value="<?php echo esc_attr($key); ?>" <?php selected( $product_type, $key ) ?>><?php echo esc_html($value); ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    <?php endif; ?>

                                    <?php do_action( 'dokan_product_edit_after_title', $post, $post_id ); ?>

                                    <div class="show_if_simple dokan-clearfix">

                                        <div class="dokan-form-group dokan-clearfix dokan-price-container">

                                            <div class="content-half-part regular-price">
                                                <label for="_regular_price" class="form-label"><?php esc_html_e( 'Price', 'gon' ); ?>
                                                    <span class="vendor-earning" data-commission="<?php echo dokan_get_seller_percentage( dokan_get_current_user_id(), $post_id ); ?>" data-commission_type="<?php echo dokan_get_commission_type( dokan_get_current_user_id(), $post_id ); ?>">( <?php esc_html_e( ' You Earn : ', 'gon' ) ?><?php echo get_woocommerce_currency_symbol() ?><span class="vendor-price">0.00</span> )</span>
                                                </label>
                                                <div class="dokan-input-group">
                                                    <span class="dokan-input-group-addon"><?php echo get_woocommerce_currency_symbol(); ?></span>
                                                    <?php dokan_post_input_box( $post_id, '_regular_price', array( 'class' => 'dokan-product-regular-price', 'placeholder' => esc_html__( '0.00', 'gon' ) ), 'number' ); ?>
                                                </div>
                                            </div>

                                            <div class="content-half-part sale-price">
                                                <label for="_sale_price" class="form-label">
                                                    <?php esc_html_e( 'Discounted Price', 'gon' ); ?>
                                                    <a href="#" class="sale_schedule <?php echo esc_attr($show_schedule ? 'dokan-hide' : ''); ?>"><?php esc_html_e( 'Schedule', 'gon' ); ?></a>
                                                    <a href="#" class="cancel_sale_schedule <?php echo ( ! $show_schedule ) ? 'dokan-hide' : ''; ?>"><?php esc_html_e( 'Cancel', 'gon' ); ?></a>
                                                </label>

                                                <div class="dokan-input-group">
                                                    <span class="dokan-input-group-addon"><?php echo get_woocommerce_currency_symbol(); ?></span>
                                                    <?php dokan_post_input_box( $post_id, '_sale_price', array( 'class' => 'dokan-product-sales-price','placeholder' => esc_html__( '0.00', 'gon' ) ), 'number' ); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="dokan-form-group dokan-clearfix dokan-price-container">
                                            <div class="dokan-product-less-price-alert dokan-hide">
                                                <?php esc_html_e('Product price can\'t be less than the vendor fee!', 'gon' ); ?>
                                            </div>
                                        </div>

                                        <div class="sale_price_dates_fields dokan-clearfix dokan-form-group <?php echo ( ! $show_schedule ) ? 'dokan-hide' : ''; ?>">
                                            <div class="content-half-part from">
                                                <div class="dokan-input-group">
                                                    <span class="dokan-input-group-addon"><?php esc_html_e( 'From', 'gon' ); ?></span>
                                                    <input type="text" name="_sale_price_dates_from" class="dokan-form-control datepicker" value="<?php echo esc_attr( $_sale_price_dates_from ); ?>" maxlength="10" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])" placeholder="<?php esc_html_e( 'YYYY-MM-DD', 'gon' ); ?>">
                                                </div>
                                            </div>

                                            <div class="content-half-part to">
                                                <div class="dokan-input-group">
                                                    <span class="dokan-input-group-addon"><?php esc_html_e( 'To', 'gon' ); ?></span>
                                                    <input type="text" name="_sale_price_dates_to" class="dokan-form-control datepicker" value="<?php echo esc_attr( $_sale_price_dates_to ); ?>" maxlength="10" pattern="[0-9]{4}-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])" placeholder="<?php esc_html_e( 'YYYY-MM-DD', 'gon' ); ?>">
                                                </div>
                                            </div>
                                        </div><!-- .sale-schedule-container -->
                                    </div>

                                    <?php if ( dokan_get_option( 'product_category_style', 'dokan_selling', 'single' ) == 'single' ): ?>
                                        <div class="dokan-form-group">
                                            <label for="product_cat" class="form-label"><?php esc_html_e( 'Category', 'gon' ); ?></label>
                                            <?php
                                            $product_cat = -1;
                                            $term = array();
                                            $term = wp_get_post_terms( $post_id, 'product_cat', array( 'fields' => 'ids') );

                                            if ( $term ) {
                                                $product_cat = reset( $term );
                                            }
                                            include_once DOKAN_LIB_DIR.'/class.category-walker.php';

                                            $category_args =  array(
                                                'show_option_none' => esc_html__( '- Select a category -', 'gon' ),
                                                'hierarchical'     => 1,
                                                'hide_empty'       => 0,
                                                'name'             => 'product_cat',
                                                'id'               => 'product_cat',
                                                'taxonomy'         => 'product_cat',
                                                'title_li'         => '',
                                                'class'            => 'product_cat dokan-form-control dokan-select2',
                                                'exclude'          => '',
                                                'selected'         => $product_cat,
                                                'walker'           => new DokanCategoryWalker( $post_id )
                                            );

                                            wp_dropdown_categories( apply_filters( 'dokan_product_cat_dropdown_args', $category_args ) );
                                        ?>
                                            <div class="dokan-product-cat-alert dokan-hide">
                                                <?php esc_html_e('Please choose a category!', 'gon' ); ?>
                                            </div>
                                        </div>
                                    <?php elseif ( dokan_get_option( 'product_category_style', 'dokan_selling', 'single' ) == 'multiple' ): ?>
                                        <div class="dokan-form-group">
                                            <label for="product_cat" class="form-label"><?php esc_html_e( 'Category', 'gon' ); ?></label>
                                            <?php
                                            $term = array();
                                            $term = wp_get_post_terms( $post_id, 'product_cat', array( 'fields' => 'ids') );
                                            include_once DOKAN_LIB_DIR.'/class.taxonomy-walker.php';
                                            $drop_down_category = wp_dropdown_categories( apply_filters( 'dokan_product_cat_dropdown_args', array(
                                                'show_option_none' => esc_html__( '', 'gon' ),
                                                'hierarchical'     => 1,
                                                'hide_empty'       => 0,
                                                'name'             => 'product_cat[]',
                                                'id'               => 'product_cat',
                                                'taxonomy'         => 'product_cat',
                                                'title_li'         => '',
                                                'class'            => 'product_cat dokan-form-control dokan-select2',
                                                'exclude'          => '',
                                                'selected'         => $term,
                                                'echo'             => 0,
                                                'walker'           => new DokanTaxonomyWalker( $post_id )
                                            ) ) );

                                            echo str_replace( '<select', '<select data-placeholder="'.esc_html__( 'Select product category', 'gon' ).'" multiple="multiple" ', $drop_down_category );
                                            ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="dokan-form-group">
                                        <label for="product_tag" class="form-label"><?php esc_html_e( 'Tags', 'gon' ); ?></label>
                                        <?php
                                        require_once DOKAN_LIB_DIR.'/class.taxonomy-walker.php';
                                        $term = wp_get_post_terms( $post_id, 'product_tag', array( 'fields' => 'ids') );
                                        $selected = ( $term ) ? $term : array();
                                        $drop_down_tags = wp_dropdown_categories( array(
                                            'show_option_none' => esc_html__( '', 'gon' ),
                                            'hierarchical'     => 1,
                                            'hide_empty'       => 0,
                                            'name'             => 'product_tag[]',
                                            'id'               => 'product_tag',
                                            'taxonomy'         => 'product_tag',
                                            'title_li'         => '',
                                            'class'            => 'product_tags dokan-form-control dokan-select2',
                                            'exclude'          => '',
                                            'selected'         => $selected,
                                            'echo'             => 0,
                                            'walker'           => new DokanTaxonomyWalker( $post_id )
                                        ) );

                                        echo str_replace( '<select', '<select data-placeholder="'.esc_html__( 'Select product tags', 'gon' ).'" multiple="multiple" ', $drop_down_tags );

                                        ?>
                                    </div>
                                </div><!-- .content-half-part -->

                                <div class="content-half-part featured-image">

                                    <div class="dokan-feat-image-upload dokan-new-product-featured-img">
                                        <?php
                                        $wrap_class        = ' dokan-hide';
                                        $instruction_class = '';
                                        $feat_image_id     = 0;

                                        if ( has_post_thumbnail( $post_id ) ) {
                                            $wrap_class        = '';
                                            $instruction_class = ' dokan-hide';
                                            $feat_image_id     = get_post_thumbnail_id( $post_id );
                                        }
                                        ?>

                                        <div class="instruction-inside<?php echo esc_attr($instruction_class); ?>">
                                            <input type="hidden" name="feat_image_id" class="dokan-feat-image-id" value="<?php echo esc_attr($feat_image_id); ?>">

                                            <i class="fa fa-cloud-upload"></i>
                                            <a href="#" class="dokan-feat-image-btn btn btn-sm"><?php esc_html_e( 'Upload a product cover image', 'gon' ); ?></a>
                                        </div>

                                        <div class="image-wrap<?php echo esc_attr($wrap_class); ?>">
                                            <a class="close dokan-remove-feat-image">&times;</a>
                                            <?php if ( $feat_image_id ) { ?>
                                                <?php echo get_the_post_thumbnail( $post_id, apply_filters( 'single_product_large_thumbnail_size', 'shop_single' ), array( 'height' => '', 'width' => '' ) ); ?>
                                            <?php } else { ?>
                                                <img height="" width="" src="" alt="<?php esc_attr_e('Product Image', 'gon'); ?>">
                                            <?php } ?>
                                        </div>
                                    </div><!-- .dokan-feat-image-upload -->

                                    <div class="dokan-product-gallery">
                                        <div class="dokan-side-body" id="dokan-product-images">
                                            <div id="product_images_container">
                                                <ul class="product_images dokan-clearfix">
                                                    <?php
                                                    $product_images = get_post_meta( $post_id, '_product_image_gallery', true );
                                                    $gallery = explode( ',', $product_images );

                                                    if ( $gallery ) {
                                                        foreach ($gallery as $image_id) {
                                                            if ( empty( $image_id ) ) {
                                                                continue;
                                                            }

                                                            $attachment_image = wp_get_attachment_image_src( $image_id, 'thumbnail' );
                                                            ?>
                                                            <li class="image" data-attachment_id="<?php echo esc_attr($image_id); ?>">
                                                                <img src="<?php echo esc_url($attachment_image[0]); ?>" alt="<?php esc_attr_e('Product Image', 'gon'); ?>">
                                                                <a href="#" class="action-delete" title="<?php esc_attr_e( 'Delete image', 'gon' ); ?>">&times;</a>
                                                            </li>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                    <li class="add-image add-product-images tips" data-title="<?php esc_html_e( 'Add gallery image', 'gon' ); ?>">
                                                        <a href="#" class="add-product-images"><i class="fa fa-plus" aria-hidden="true"></i></a>
                                                    </li>
                                                </ul>

                                                <input type="hidden" id="product_image_gallery" name="product_image_gallery" value="<?php echo esc_attr( $product_images ); ?>">
                                            </div>
                                        </div>
                                    </div> <!-- .product-gallery -->
                                </div><!-- .content-half-part -->
                            </div><!-- .dokan-form-top-area -->

                            <div class="dokan-product-short-description">
                                <label for="post_excerpt" class="form-label"><?php esc_html_e( 'Short Description', 'gon' ); ?></label>
                                <?php wp_editor( $post_excerpt , 'post_excerpt', array('editor_height' => 50, 'quicktags' => false, 'media_buttons' => false, 'teeny' => true, 'editor_class' => 'post_excerpt') ); ?>
                            </div>

                            <div class="dokan-product-description">
                                <label for="post_content" class="form-label"><?php esc_html_e( 'Description', 'gon' ); ?></label>
                                <?php wp_editor( $post_content , 'post_content', array('editor_height' => 50, 'quicktags' => false, 'media_buttons' => false, 'teeny' => true, 'editor_class' => 'post_content') ); ?>
                            </div>

                            <?php do_action( 'dokan_new_product_form', $post, $post_id ); ?>
                            <?php do_action( 'dokan_product_edit_after_main', $post, $post_id ); ?>

                            <?php do_action( 'dokan_product_edit_after_inventory_variants', $post, $post_id ); ?>

                            <?php if ( $post_id ): ?>
                                <?php do_action( 'dokan_product_edit_after_options', $post_id ); ?>
                            <?php endif; ?>

                            <?php wp_nonce_field( 'dokan_edit_product', 'dokan_edit_product_nonce' ); ?>

                            <!--hidden input for Firefox issue-->
                            <input type="hidden" name="dokan_update_product" value="<?php esc_attr_e( 'Save Product', 'gon' ); ?>"/>
                            <input type="submit" name="dokan_update_product" class="dokan-btn dokan-btn-theme dokan-btn-lg dokan-right" value="<?php esc_attr_e( 'Save Product', 'gon' ); ?>"/>
                            <div class="dokan-clearfix"></div>
                        </form>
                    <?php } else { ?>
                        <div class="dokan-alert dokan-alert">
                            <?php echo dokan_seller_not_enabled_notice(); ?>
                        </div>
                    <?php } ?>

                <?php } else { ?>

                    <?php do_action( 'dokan_can_post_notice' ); ?>

                <?php } ?>
            </div> <!-- #primary .content-area -->

            <?php

                /**
                 *  dokan_product_content_inside_area_after hook
                 *
                 *  @since 2.4
                 */
                do_action( 'dokan_product_content_inside_area_after' );
            ?>
        </div>

        <?php

            /**
             *  dokan_dashboard_content_after hook
             *  dokan_after_product_content_area hook
             *
             *  @since 2.4
             */
            do_action( 'dokan_dashboard_content_after' );
            do_action( 'dokan_after_product_content_area' );
        ?>

    </div><!-- .dokan-dashboard-wrap -->

<?php do_action( 'dokan_dashboard_wrap_end' ); ?>
<?php if( ! $from_shortcode ): ?>
</div>
</div>
<?php endif; ?>
<div class="dokan-clearfix"></div>

<?php

    /**
     *  dokan_dashboard_content_before hook
     *
     *  @since 2.4
     */
    do_action( 'dokan_dashboard_wrap_after', $post, $post_id );

    wp_reset_postdata();

    if ( ! $from_shortcode ) {
        get_footer();
    }
?>
