<?php 
/**
 * SMOF Interface
 *
 * @package     WordPress
 * @subpackage  SMOF
 * @since       1.4.0
 * @author      Syamil MJ
 */
 
 
/**
 * Admin Init
 *
 * @uses wp_verify_nonce()
 * @uses header()
 *
 * @since 1.0.0
 */
function gon_optionsframework_admin_init() 
{
	// Rev up the Options Machine
	global $gon_of_options, $gon_options_machine, $smof_data, $gon_smof_details;
	if( !isset($gon_options_machine) ){
		$gon_options_machine = new Gon_Options_Machine($gon_of_options);
	}

	do_action('gon_optionsframework_admin_init_before', array(
			'of_options'		=> $gon_of_options,
			'options_machine'	=> $gon_options_machine,
			'smof_data'			=> $smof_data
		));
	
	if (empty($smof_data['smof_init'])) { // Let's set the values if the theme's already been active
		gon_of_save_options($gon_options_machine->Defaults);
		gon_of_save_options(date('r'), 'smof_init');
		$smof_data = gon_of_get_options();
		$gon_options_machine = new Gon_Options_Machine($gon_of_options);
	}

	do_action('gon_optionsframework_admin_init_after', array(
			'of_options'		=> $gon_of_options,
			'options_machine'	=> $gon_options_machine,
			'smof_data'			=> $smof_data
		));

}

/**
 * Create Options page
 *
 * @uses add_theme_page()
 * @uses add_action()
 *
 * @since 1.0.0
 */
function gon_optionsframework_add_admin() {
	
    $of_page = add_theme_page( THEMENAME, 'Theme Options', 'edit_theme_options', 'optionsframework', 'gon_optionsframework_options_page');

	// Add framework functionaily to the head individually
	add_action("admin_print_scripts-$of_page", 'gon_of_load_only');
	add_action("admin_print_styles-$of_page",'gon_of_style_only');
	
}

function gon_theme_options_get_menu_html(){
	global $gon_options_machine;
	return $gon_options_machine->Menu;
}

function gon_theme_options_get_options_html(){
	global $gon_options_machine;
	return $gon_options_machine->Inputs;
}

/**
 * Build Options page
 *
 * @since 1.0.0
 */
function gon_optionsframework_options_page(){
	global $gon_options_machine;	
	
	include_once( ADMIN_PATH . 'front-end/options.php' );
}

/**
 * Create Options page
 *
 * @uses wp_enqueue_style()
 *
 * @since 1.0.0
 */
function gon_of_style_only(){
	wp_enqueue_style('gon-of-admin-style', ADMIN_DIR . 'assets/css/admin-style.css');
	wp_enqueue_style('jquery-ui-custom-admin', ADMIN_DIR .'assets/css/jquery-ui-custom.css');

	if ( !wp_style_is( 'wp-color-picker','registered' ) ) {
		wp_register_style( 'wp-color-picker', ADMIN_DIR . 'assets/css/color-picker.min.css' );
	}
	wp_enqueue_style( 'wp-color-picker' );
	do_action('gon_of_style_only_after');
}	

/**
 * Create Options page
 *
 * @uses add_action()
 * @uses wp_enqueue_script()
 *
 * @since 1.0.0
 */
function gon_of_load_only() 
{
	
	wp_enqueue_script('jquery-ui-core');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');
	wp_enqueue_script('jquery-input-mask', ADMIN_DIR .'assets/js/jquery.maskedinput-1.2.2.js', array( 'jquery' ));
	wp_enqueue_script('tipsy', ADMIN_DIR .'assets/js/jquery.tipsy.js', array( 'jquery' ));
	wp_enqueue_script('cookie', ADMIN_DIR . 'assets/js/cookie.js', 'jquery');
	wp_enqueue_script('smof', ADMIN_DIR .'assets/js/smof.js', array( 'jquery' ));
	
	/* ace editor */
	wp_enqueue_script('ace-editor', ADMIN_DIR .'assets/js/ace/ace.js', array( 'jquery' ), false, true);
	wp_enqueue_script('theme-monokai', ADMIN_DIR .'assets/js/ace/theme-monokai.js', array( 'jquery' ), false, true);


	// Enqueue colorpicker scripts for versions below 3.5 for compatibility
	if ( !wp_script_is( 'wp-color-picker', 'registered' ) ) {
		wp_register_script( 'iris', ADMIN_DIR .'assets/js/iris.min.js', array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ), false, 1 );
		wp_register_script( 'wp-color-picker', ADMIN_DIR .'assets/js/color-picker.min.js', array( 'jquery', 'iris' ) );
	}
	wp_enqueue_script( 'wp-color-picker' );
	

	/**
	 * Enqueue scripts for file uploader
	 */
	
	if( function_exists( 'wp_enqueue_media' ) ){
		wp_enqueue_media();
	}

	do_action('gon_of_load_only_after');

}


/**
 * Ajax Save Options
 *
 * @uses get_option()
 *
 * @since 1.0.0
 */
function gon_of_ajax_callback() 
{
	global $gon_options_machine, $gon_of_options;

	$nonce = $_POST['security'];
	
	if( ! wp_verify_nonce($nonce, 'of_ajax_nonce') ){
		die('-1');
	}
			
	//get options array from db
	$all = gon_of_get_options();
	
	$save_type = $_POST['type'];
	
	//Uploads
	if($save_type == 'upload')
	{
		
		$clickedID = $_POST['data']; // Acts as the name
		$filename = $_FILES[$clickedID];
       	$filename['name'] = preg_replace('/[^a-zA-Z0-9._\-]/', '', $filename['name']); 
		
		$override['test_form'] = false;
		$override['action'] = 'wp_handle_upload';    
		$uploaded_file = wp_handle_upload($filename,$override);
		 
			$upload_tracking[] = $clickedID;
				
			//update $options array w/ image URL			  
			$upload_image = $all; //preserve current data
			
			$upload_image[$clickedID] = $uploaded_file['url'];
			
			gon_of_save_options($upload_image);
		
				
		if( !empty($uploaded_file['error']) ){
			echo esc_html__('Upload Error: ', 'gon') . $uploaded_file['error']; 
		}else{
			echo esc_url($uploaded_file['url']); 
		}
	}
	elseif($save_type == 'image_reset')
	{
			
			$id = $_POST['data']; // Acts as the name
			
			$delete_image = $all; //preserve rest of data
			$delete_image[$id] = ''; //update array key with empty value	 
			gon_of_save_options($delete_image ) ;
	
	}
	elseif($save_type == 'backup_options')
	{
			
		$backup = $all;
		$backup['backup_log'] = date('r');
		
		gon_of_save_options($backup, BACKUPS) ;
			
		die('1'); 
	}
	elseif($save_type == 'restore_options')
	{
			
		$smof_data = gon_of_get_options(BACKUPS);

		gon_of_save_options($smof_data);
		
		die('1'); 
	}
	elseif($save_type == 'import_options'){


		$smof_data = json_decode(stripslashes($_POST['data']), true);
		gon_of_save_options($smof_data);

		
		die('1'); 
	}
	elseif ($save_type == 'save')
	{

		wp_parse_str(stripslashes($_POST['data']), $smof_data);
		unset($smof_data['security']);
		unset($smof_data['of_save']);
		gon_of_save_options($smof_data);
		
		
		die('1');
	}
	elseif ($save_type == 'reset')
	{
		gon_of_save_options($gon_options_machine->Defaults);
		
        die('1'); //options reset
	}

  	die();
}
