<?php
add_action('widgets_init', 'ts_social_icons_load_widgets');

function ts_social_icons_load_widgets()
{
	register_widget('TS_Social_Icons_Widget');
}

if( !class_exists('TS_Social_Icons_Widget') ){
	class TS_Social_Icons_Widget extends WP_Widget {

		function __construct() {
			$widgetOps = array('classname' => 'ts-social-icons', 'description' => esc_html__('Display Your Social Icons','themesky'));
			parent::__construct('ts_social_icons', esc_html__('TS - Social Icons','themesky'), $widgetOps);
		}

		function widget( $args, $instance ) {
			extract($args);
			$title = apply_filters('widget_title', $instance['title']);
			
			$desc = esc_html( $instance['desc'] );
			
			$facebook_id 		= esc_attr($instance['facebook_id']);
			$twitter_id 		= esc_attr($instance['twitter_id']);
			$flickr_id 			= esc_attr($instance['flickr_id']);
			$vimeo_id 			= esc_attr($instance['vimeo_id']);
			$feedburner_id 		= esc_attr($instance['feedburner_id']);
			$youtube_id 		= isset($instance['youtube_id'])?esc_attr($instance['youtube_id']):'';
			$viber_id 			= isset($instance['viber_id'])?esc_attr($instance['viber_id']):'';
			$skype_id 			= isset($instance['skype_id'])?esc_attr($instance['skype_id']):'';
			$instagram_id 		= isset($instance['instagram_id'])?esc_attr($instance['instagram_id']):'';
			$custom_link 		= esc_attr($instance['custom_link']);
			$custom_text 		= esc_html($instance['custom_text']);
			$custom_font 		= esc_attr($instance['custom_font']);
			$show_tooltip 		= $instance['show_tooltip'];
			$social_style 		= $instance['social_style'];
			
			$extra_class = ($show_tooltip)?'ts-tooltip social-tooltip':'';
			
			echo $before_widget;
			
			if( empty($title) ){
				$before_title = '<h3 class="widget-title heading-title hidden">';
				$after_title = '</h3>';
				$title = 'Social Icons';
			}
			echo $before_title . $title . $after_title;
			?>
			
			<div class="social-icons <?php echo esc_attr($social_style) ?>">
				<?php if( strlen(trim($desc)) > 0 ): ?>
				<div class="social-desc">
					<?php echo esc_html($desc); ?>
				</div>
				<?php endif; ?>
				<ul class="list-icons">
					<?php if( $facebook_id !== "" ): ?>
						<li><a class="facebook" href="http://www.facebook.com/<?php echo esc_attr($facebook_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Become our fan', 'themesky'):''; ?>" ><i class="fa fa-facebook"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Facebook', 'themesky'); ?></span></a></li>				
					<?php endif; ?>
					<?php if( $twitter_id !== "" ): ?>
						<li><a class="twitter" href="http://twitter.com/<?php echo esc_attr($twitter_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Follow us', 'themesky'):''; ?>" ><i class="fa fa-twitter"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Twitter', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $flickr_id !== "" ): ?>
						<li><a class="flickr" href="http://www.flickr.com/photos/<?php echo esc_attr($flickr_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('See Us', 'themesky'):''; ?>" ><i class="fa fa-flickr"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Flickr', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $vimeo_id !== "" ): ?>
						<li><a class="vimeo" href="http://vimeo.com/<?php echo esc_attr($vimeo_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Watch Us', 'themesky'):''; ?>" ><i class="fa fa-vimeo-square"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Vimeo', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $feedburner_id !== "" ): ?>
						<li><a class="feedburner" href="http://feeds.feedburner.com/<?php echo esc_attr($feedburner_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Get updates', 'themesky'):''; ?>" ><i class="fa fa-rss"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('RSS', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $youtube_id !== "" ): ?>
						<li><a class="youtube" href="https://www.youtube.com/user/<?php echo esc_attr($youtube_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Watch Us', 'themesky'):''; ?>" ><i class="fa fa-youtube-square"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Youtube', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $viber_id !== "" ): ?>
						<li><a class="viber" href="viber://<?php echo esc_attr($viber_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Call Us', 'themesky'):''; ?>" ><i class="fa fa-phone"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Viber', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $skype_id !== "" ): ?>
						<li><a class="skype" href="skype:<?php echo esc_attr($skype_id); ?>?chat" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('Chat With Us', 'themesky'):''; ?>" ><i class="fa fa-skype"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Skype', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $instagram_id !== "" ): ?>
						<li><a class="instagram" href="https://instagram.com/<?php echo esc_attr($instagram_id); ?>" target="_blank" title="<?php echo (!$show_tooltip)?esc_html__('See Us', 'themesky'):''; ?>" ><i class="fa fa-instagram"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php esc_html_e('Instagram', 'themesky'); ?></span></a></li>
					<?php endif; ?>
					<?php if( $custom_link !== "" ): ?>
						<li><a class="custom-icon" href="<?php echo esc_url($custom_link); ?>" target="_blank" title="<?php echo (!$show_tooltip)?$custom_text:''; ?>" ><i class="fa <?php echo esc_attr($custom_font); ?>"></i><span class="<?php echo esc_attr($extra_class); ?>"><?php echo esc_html($custom_text); ?></span></a></li>
					<?php endif; ?>
				</ul>
			</div>

			<?php
			echo $after_widget;
		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;		
			$instance['title'] 			= $new_instance['title'];
			$instance['desc'] 			=  $new_instance['desc'];
			$instance['facebook_id'] 	=  $new_instance['facebook_id'];
			$instance['twitter_id'] 	=  $new_instance['twitter_id'];			
			$instance['flickr_id'] 		=  $new_instance['flickr_id'];		
			$instance['vimeo_id'] 		=  $new_instance['vimeo_id'];		
			$instance['feedburner_id'] 	=  $new_instance['feedburner_id'];
			$instance['youtube_id'] 	=  $new_instance['youtube_id'];
			$instance['viber_id'] 		=  $new_instance['viber_id'];		
			$instance['skype_id'] 		=  $new_instance['skype_id'];		
			$instance['instagram_id'] 	=  $new_instance['instagram_id'];
			$instance['custom_link'] 	=  $new_instance['custom_link'];		
			$instance['custom_text'] 	=  $new_instance['custom_text'];		
			$instance['custom_font'] 	=  $new_instance['custom_font'];		
			$instance['show_tooltip'] 	=  $new_instance['show_tooltip'];
			$instance['social_style']	=  $new_instance['social_style'];
			return $instance;
		}

		function form( $instance ) {
			
			$defaults = array(
				'title'			=> ''
				,'desc'				=> ''
				,'facebook_id' 		=> ''
				,'twitter_id' 		=> ''
				,'flickr_id' 		=> ''
				,'vimeo_id'			=> '' 
				,'feedburner_id' 	=> ''
				,'youtube_id'		=> ''
				,'viber_id'			=> ''
				,'skype_id'			=> ''
				,'instagram_id'		=> ''
				,'custom_link' 		=> ''
				,'custom_text' 		=> ''
				,'custom_font' 		=> ''
				,'show_tooltip'		=> 1 
				,'social_style'		=> 'style-1' 
			);
		
			$instance = wp_parse_args( (array) $instance, $defaults );	
		?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Enter your title', 'themesky'); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('social_style'); ?>"><?php esc_html_e('Social style', 'themesky'); ?></label>
				<select class="widefat" id="<?php echo $this->get_field_id('social_style'); ?>" name="<?php echo $this->get_field_name('social_style'); ?>">
					<option value="style-1" <?php selected($instance['social_style'], 'style-1'); ?>><?php esc_html_e('Style 1', 'themesky'); ?></option>
					<option value="style-2" <?php selected($instance['social_style'], 'style-2'); ?>><?php esc_html_e('Style 2', 'themesky'); ?></option>
					<option value="style-3" <?php selected($instance['social_style'], 'style-3'); ?>><?php esc_html_e('Style 3', 'themesky'); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('desc'); ?>"><?php esc_html_e('Enter description about your social icons', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('desc'); ?>" name="<?php echo $this->get_field_name('desc'); ?>" value="<?php echo esc_attr($instance['desc']); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('facebook_id'); ?>"><?php esc_html_e('Facebook ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('facebook_id'); ?>" name="<?php echo $this->get_field_name('facebook_id'); ?>" value="<?php echo esc_attr($instance['facebook_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('twitter_id'); ?>"><?php esc_html_e('Twitter ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('twitter_id'); ?>" name="<?php echo $this->get_field_name('twitter_id'); ?>" value="<?php echo esc_attr($instance['twitter_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('flickr_id'); ?>"><?php esc_html_e('Flickr ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('flickr_id'); ?>" name="<?php echo $this->get_field_name('flickr_id'); ?>" value="<?php echo esc_attr($instance['flickr_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('vimeo_id'); ?>"><?php esc_html_e('Vimeo ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('vimeo_id'); ?>" name="<?php echo $this->get_field_name('vimeo_id'); ?>" value="<?php echo esc_attr($instance['vimeo_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('feedburner_id'); ?>"><?php esc_html_e('FeedBurner ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('feedburner_id'); ?>" name="<?php echo $this->get_field_name('feedburner_id'); ?>" value="<?php echo esc_attr($instance['feedburner_id']); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('youtube_id'); ?>"><?php esc_html_e('Youtube ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('youtube_id'); ?>" name="<?php echo $this->get_field_name('youtube_id'); ?>" value="<?php echo esc_attr($instance['youtube_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('viber_id'); ?>"><?php esc_html_e('Viber Number', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('viber_id'); ?>" name="<?php echo $this->get_field_name('viber_id'); ?>" value="<?php echo esc_attr($instance['viber_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('skype_id'); ?>"><?php esc_html_e('Skype ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('skype_id'); ?>" name="<?php echo $this->get_field_name('skype_id'); ?>" value="<?php echo esc_attr($instance['skype_id']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('instagram_id'); ?>"><?php esc_html_e('Instagram ID', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('instagram_id'); ?>" name="<?php echo $this->get_field_name('instagram_id'); ?>" value="<?php echo esc_attr($instance['instagram_id']); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('custom_link'); ?>"><?php esc_html_e('Custom Link', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('custom_link'); ?>" name="<?php echo $this->get_field_name('custom_link'); ?>" value="<?php echo esc_attr($instance['custom_link']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('custom_text'); ?>"><?php esc_html_e('Custom Text - Show on tooltip', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('custom_text'); ?>" name="<?php echo $this->get_field_name('custom_text'); ?>" value="<?php echo esc_attr($instance['custom_text']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('custom_font'); ?>"><?php esc_html_e('Custom Font - Use FontAwesome class', 'themesky'); ?></label>
				<input class="widefat" type="text" id="<?php echo $this->get_field_id('custom_font'); ?>" name="<?php echo $this->get_field_name('custom_font'); ?>" value="<?php echo esc_attr($instance['custom_font']); ?>" />
			</p>
			<p>
				<input type="checkbox" id="<?php echo $this->get_field_id('show_tooltip'); ?>" name="<?php echo $this->get_field_name('show_tooltip'); ?>" value="1" <?php checked($instance['show_tooltip'], 1); ?> />
				<label for="<?php echo $this->get_field_id('show_tooltip'); ?>"><?php esc_html_e('Show Tooltip', 'themesky'); ?></label>
			</p>
			<?php 
		}
	}
}