<?php 
/**
 * Plugin Name: ThemeSky
 * Plugin URI: http://theme-sky.com
 * Description: Add shortcodes and custom post types for Gon theme
 * Version: 1.2.5
 * Author: ThemeSky Team
 * Author URI: http://theme-sky.com
 */
class ThemeSky_Plugin{

	function __construct(){
		$this->load_language_file();
		$this->include_files();
		$this->register_widgets();
		
		/* Fix bbpress setup current user */
		remove_action( 'set_current_user', 'bbp_setup_current_user', 10);
		add_action( 'init', array($this, 'bbp_setup_current_user'));
	}
	
	function load_language_file(){
		load_plugin_textdomain('themesky', false, basename( dirname( __FILE__ ) ) . '/languages' );
	}
	
	function include_files(){
		require_once('register_post_type.php');
		require_once('class-shortcodes.php');
		require_once('includes/twitteroauth.php');
	}
	
	function register_widgets(){
		$file_names = array('banner', 'single_image', 'product_deals', 'logos_slider', 'footer_block', 'testimonial', 'twitter');
		foreach( $file_names as $file_name ){
			$file = plugin_dir_path( __FILE__ ) . '/widgets/' . $file_name . '.php';
			if( file_exists($file) ){
				require_once($file);
			}
		}
	}
	
	function bbp_setup_current_user(){
		if( function_exists('bbp_setup_current_user') ){
			add_action( 'set_current_user', 'bbp_setup_current_user', 10);
		}
	}
	
}
new ThemeSky_Plugin();
?>